/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.commands.State;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.dialog.DisplayedAxisSelectorDialog;
import org.eclipse.papyrus.infra.nattable.manager.axis.AxisManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.axis.CompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.AbstractNattableWidgetManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.IMasterAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.ISlaveAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.CellEditorDeclaration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.NattableconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.FeatureLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ILabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablelabelprovider.ObjectLabelProviderConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.StringComparator;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.providers.FlattenableRestrictedFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class NattableModelManager
extends AbstractNattableWidgetManager
implements INattableModelManager {
    private ICompositeAxisManager columnManager;
    private ICompositeAxisManager rowManager;
    private List<Object> verticalElements;
    private List<Object> horizontalElements;
    private Adapter invertAxisListener;
    private AbstractAxisProvider rowProvider;
    private AbstractAxisProvider columnProvider;
    private CommandStackListener refreshListener;
    private FocusListener focusListener;
    private TransactionalEditingDomain contextEditingDomain;

    public NattableModelManager(Table rawModel) {
        super(rawModel);
        this.rowProvider = rawModel.getCurrentRowAxisProvider();
        this.columnProvider = rawModel.getCurrentColumnAxisProvider();
        this.verticalElements = Collections.synchronizedList(new ArrayList());
        this.horizontalElements = Collections.synchronizedList(new ArrayList());
        this.invertAxisListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getEventType() == 1) {
                    Object oldValue = msg.getOldValue();
                    Object newValue = msg.getNewValue();
                    if (oldValue != null && newValue != null && msg.getFeature() == NattablePackage.eINSTANCE.getTable_InvertAxis()) {
                        NattableModelManager.this.invertJavaObject();
                    }
                }
            }
        };
        rawModel.eAdapters().add((Object)this.invertAxisListener);
        this.init();
        if (rawModel.isInvertAxis()) {
            this.invertJavaObject();
        }
    }

    @Override
    public NatTable createNattable(Composite parent, int style, IWorkbenchPartSite site) {
        final NatTable nattable = super.createNattable(parent, style, site);
        this.refreshListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (nattable != null && !nattable.isDisposed() && nattable.isVisible()) {
                            nattable.refresh();
                        }
                    }
                });
            }
        };
        this.getContextEditingDomain().getCommandStack().addCommandStackListener(this.refreshListener);
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                NattableModelManager.this.updateToggleActionState();
            }
        };
        nattable.addFocusListener(this.focusListener);
        this.updateToggleActionState();
        return nattable;
    }

    protected void updateToggleActionState() {
        org.eclipse.core.commands.Command command;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        if (commandService != null) {
            FeatureLabelProviderConfiguration labelFeatureConf;
            ObjectLabelProviderConfiguration labelConfig;
            AbstractHeaderAxisConfiguration columnAxisConfiguration = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisUsedInTable(this.getTable());
            AbstractHeaderAxisConfiguration rowAxisConfiguration = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisUsedInTable(this.getTable());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.display.index");
            this.updateToggleCommandState(command, columnAxisConfiguration.isDisplayIndex());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.display.label");
            this.updateToggleCommandState(command, columnAxisConfiguration.isDisplayLabel());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.index.style");
            this.updateRadioCommandState(command, columnAxisConfiguration.getIndexStyle().getLiteral());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.display.index");
            this.updateToggleCommandState(command, rowAxisConfiguration.isDisplayIndex());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.display.label");
            this.updateToggleCommandState(command, rowAxisConfiguration.isDisplayLabel());
            command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.index.style");
            this.updateRadioCommandState(command, rowAxisConfiguration.getIndexStyle().getLiteral());
            EList columnLabelConfigurations = columnAxisConfiguration.getOwnedLabelConfigurations();
            EList rowLabelConfigurations = rowAxisConfiguration.getOwnedLabelConfigurations();
            for (ILabelProviderConfiguration current : columnLabelConfigurations) {
                if (!(current instanceof ObjectLabelProviderConfiguration)) continue;
                labelConfig = (ObjectLabelProviderConfiguration)current;
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.display.icon");
                this.updateToggleCommandState(command, labelConfig.isDisplayIcon());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.display.label");
                this.updateToggleCommandState(command, labelConfig.isDisplayLabel());
                if (!(labelConfig instanceof FeatureLabelProviderConfiguration)) continue;
                labelFeatureConf = (FeatureLabelProviderConfiguration)labelConfig;
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.feature.display.isderived");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayIsDerived());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.feature.display.multiplicity");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayMultiplicity());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.feature.display.type");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayType());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.label.feature.display.name");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayName());
            }
            for (ILabelProviderConfiguration current : rowLabelConfigurations) {
                if (!(current instanceof ObjectLabelProviderConfiguration)) continue;
                labelConfig = (ObjectLabelProviderConfiguration)current;
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.display.icon");
                this.updateToggleCommandState(command, labelConfig.isDisplayIcon());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.display.label");
                this.updateToggleCommandState(command, labelConfig.isDisplayLabel());
                if (!(labelConfig instanceof FeatureLabelProviderConfiguration)) continue;
                labelFeatureConf = (FeatureLabelProviderConfiguration)labelConfig;
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.feature.display.isderived");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayIsDerived());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.feature.display.multiplicity");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayMultiplicity());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.feature.display.type");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayType());
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.label.feature.display.name");
                this.updateToggleCommandState(command, labelFeatureConf.isDisplayName());
            }
            if (this.columnProvider instanceof ISlaveAxisProvider) {
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.row.disconnect.slave");
                this.updateToggleCommandState(command, ((IMasterAxisProvider)this.rowProvider).isDisconnectSlave());
            }
            if (this.rowProvider instanceof ISlaveAxisProvider) {
                command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.disconnect.slave");
                this.updateToggleCommandState(command, ((IMasterAxisProvider)this.columnProvider).isDisconnectSlave());
            }
        } else {
            throw new RuntimeException(String.format("The Eclipse service {0} has not been found", ICommandService.class));
        }
        command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.invert.axis");
        this.updateToggleCommandState(command, this.getTable().isInvertAxis());
    }

    private void updateToggleCommandState(org.eclipse.core.commands.Command command, boolean newValue) {
        State state;
        if (command != null && (state = command.getState("org.eclipse.ui.commands.toggleState")) != null) {
            state.setValue((Object)newValue);
        }
    }

    private void updateRadioCommandState(org.eclipse.core.commands.Command command, Object newValue) {
        State state;
        if (command != null && (state = command.getState("org.eclipse.ui.commands.radioState")) != null) {
            state.setValue(newValue);
        }
    }

    public void invertJavaObject() {
        AbstractAxisProvider newColumProvider = this.rowProvider;
        AbstractAxisProvider newRowProvider = this.columnProvider;
        List<Object> newVerticalElementList = this.horizontalElements;
        List<Object> newHorizontalElementList = this.verticalElements;
        ICompositeAxisManager newRowManager = this.columnManager;
        ICompositeAxisManager newColumnManager = this.rowManager;
        this.columnProvider = newColumProvider;
        this.rowProvider = newRowProvider;
        this.verticalElements = newVerticalElementList;
        this.horizontalElements = newHorizontalElementList;
        this.rowManager = newRowManager;
        this.columnManager = newColumnManager;
        this.updateToggleActionState();
        this.configureNatTable();
        this.refreshNatTable();
    }

    protected void init() {
        this.columnManager = this.createAxisManager((List<AxisManagerRepresentation>)this.getTable().getTableConfiguration().getColumnHeaderAxisConfiguration().getAxisManagers(), this.getTable().getCurrentColumnAxisProvider());
        this.rowManager = this.createAxisManager((List<AxisManagerRepresentation>)this.getTable().getTableConfiguration().getRowHeaderAxisConfiguration().getAxisManagers(), this.getTable().getCurrentRowAxisProvider());
        boolean allIsSlave = this.columnManager.isSlave() && this.rowManager.isSlave();
        Assert.isTrue((!allIsSlave ? 1 : 0) != 0, (String)Messages.NattableModelManager_AtLeastOfOneTheAxisManagerMustBeAMaster);
    }

    protected ICompositeAxisManager createAxisManager(List<AxisManagerRepresentation> representations, AbstractAxisProvider contentProvider) {
        ArrayList<IAxisManager> managers = new ArrayList<IAxisManager>();
        for (AxisManagerRepresentation current : representations) {
            IAxisManager manager = AxisManagerFactory.INSTANCE.getAxisManager(current);
            assert (manager != null);
            manager.init(this, current, contentProvider);
            managers.add(manager);
        }
        CompositeAxisManager compositeAxisManager = new CompositeAxisManager();
        compositeAxisManager.init(this, null, contentProvider);
        compositeAxisManager.setSubAxisManager(managers);
        return compositeAxisManager;
    }

    @Override
    public void dispose() {
        this.columnManager.dispose();
        this.rowManager.dispose();
        this.getContextEditingDomain().getCommandStack().removeCommandStackListener(this.refreshListener);
    }

    @Override
    public void addRows(Collection<Object> objectsToAdd) {
        EditingDomain domain = this.getContextEditingDomain();
        Command cmd = this.getAddRowElementCommand(objectsToAdd);
        if (cmd != null && cmd.canExecute()) {
            domain.getCommandStack().execute(cmd);
        }
    }

    @Override
    public int getColumnCount() {
        return this.getColumnElementsList().size();
    }

    @Override
    public int getRowCount() {
        return this.getRowElementsList().size();
    }

    @Override
    public void addColumns(Collection<Object> objectsToAdd) {
        EditingDomain domain = this.getContextEditingDomain();
        Command cmd = this.getAddColumnElementCommand(objectsToAdd);
        if (cmd != null && cmd.canExecute()) {
            domain.getCommandStack().execute(cmd);
        }
    }

    private EditingDomain getTableEditingDomain() {
        ServicesRegistry registry = null;
        try {
            registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)this.getTable());
            return (EditingDomain)registry.getService(EditingDomain.class);
        }
        catch (ServiceException e) {
            Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            return null;
        }
    }

    private EditingDomain getContextEditingDomain() {
        if (this.contextEditingDomain == null) {
            ServicesRegistry registry = null;
            try {
                registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.getTableContext());
                this.contextEditingDomain = (TransactionalEditingDomain)registry.getService(TransactionalEditingDomain.class);
            }
            catch (ServiceException e) {
                Activator.log.error(Messages.NattableModelManager_ServiceRegistryNotFound, (Throwable)e);
            }
        }
        return this.contextEditingDomain;
    }

    @Override
    public IDataProvider getBodyDataProvider() {
        return this;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        Object obj1 = this.verticalElements.get(columnIndex);
        Object obj2 = this.horizontalElements.get(rowIndex);
        return CellManagerFactory.INSTANCE.getCrossValue(obj1, obj2);
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        Object obj1 = this.verticalElements.get(columnIndex);
        Object obj2 = this.horizontalElements.get(rowIndex);
        CellManagerFactory.INSTANCE.setCellValue(this.getContextEditingDomain(), obj1, obj2, newValue);
    }

    public void refreshNatTable() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                NattableModelManager.this.natTable.refresh();
            }
        });
    }

    public void updateAxisContents(final AbstractAxisProvider axis) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (NattableModelManager.this.natTable != null && !NattableModelManager.this.natTable.isDisposed()) {
                    if (axis == NattableModelManager.this.columnProvider) {
                        NattableModelManager.this.updateColumnContents();
                    } else {
                        NattableModelManager.this.updateRowContents();
                    }
                }
            }
        });
    }

    private void updateRowContents() {
        this.rowManager.updateAxisContents();
        CellEditorDeclaration declaration = this.getCellEditorDeclarationToUse(this.getTable());
        if (declaration.equals((Object)CellEditorDeclaration.ROW)) {
            this.configureNatTable();
            this.refreshNatTable();
        } else {
            this.refreshNatTable();
        }
    }

    private void updateColumnContents() {
        this.columnManager.updateAxisContents();
        CellEditorDeclaration declaration = this.getCellEditorDeclarationToUse(this.getTable());
        if (declaration.equals((Object)CellEditorDeclaration.COLUMN)) {
            this.configureNatTable();
            this.refreshNatTable();
        } else {
            this.refreshNatTable();
        }
    }

    private CellEditorDeclaration getCellEditorDeclarationToUse(Table table) {
        CellEditorDeclaration declaration = table.getTableConfiguration().getCellEditorDeclaration();
        if (this.getTable().isInvertAxis()) {
            if (declaration.equals((Object)CellEditorDeclaration.COLUMN)) {
                declaration = CellEditorDeclaration.ROW;
            } else if (declaration.equals((Object)CellEditorDeclaration.ROW)) {
                declaration = CellEditorDeclaration.COLUMN;
            }
        }
        return declaration;
    }

    @Override
    public List<Object> getColumnElementsList() {
        return this.verticalElements;
    }

    @Override
    public List<Object> getRowElementsList() {
        return this.horizontalElements;
    }

    @Override
    public boolean canInsertRow(Collection<Object> objectsToAdd, int index) {
        return this.rowManager.canInsertAxis(objectsToAdd, index);
    }

    @Override
    public boolean canInsertColumns(Collection<Object> objectsToAdd, int index) {
        return this.columnManager.canInsertAxis(objectsToAdd, index);
    }

    @Override
    public boolean canDropColumnsElement(Collection<Object> objectsToAdd) {
        return this.columnManager.canDropAxisElement(objectsToAdd);
    }

    @Override
    public boolean canDropRowElement(Collection<Object> objectsToAdd) {
        return this.rowManager.canDropAxisElement(objectsToAdd);
    }

    @Override
    public void insertRows(Collection<Object> objectsToAdd, int index) {
        this.rowManager.getInsertAxisCommand(objectsToAdd, index);
    }

    @Override
    public void insertColumns(Collection<Object> objectsToAdd, int index) {
        this.columnManager.getInsertAxisCommand(objectsToAdd, index);
    }

    @Override
    public Object getColumnElement(int index) {
        return this.verticalElements.get(index);
    }

    @Override
    public Object getRowElement(int index) {
        return this.horizontalElements.get(index);
    }

    @Override
    public List<Object> getElementsList(AbstractAxisProvider axisProvider) {
        if (axisProvider == this.columnProvider) {
            return this.verticalElements;
        }
        if (axisProvider == this.rowProvider) {
            return this.horizontalElements;
        }
        return null;
    }

    @Override
    public boolean canMoveRows() {
        return this.rowManager.canMoveAxis();
    }

    @Override
    public boolean canMoveColumns() {
        return this.columnManager.canMoveAxis();
    }

    @Override
    public void moveColumnElement(Object axisToMove, int newIndex) {
        this.columnManager.moveAxis(axisToMove, newIndex);
    }

    @Override
    public void moveRowElement(Object axisToMove, int newIndex) {
        this.rowManager.moveAxis(axisToMove, newIndex);
    }

    @Override
    public void invertAxis() {
        CompoundCommand cmd = new CompoundCommand(Messages.NattableModelManager_SwitchLinesAndColumns);
        EditingDomain domain = this.getContextEditingDomain();
        boolean oldValue = this.getTable().isInvertAxis();
        if (this.canInvertAxis()) {
            SetCommand tmp = new SetCommand(domain, (EObject)this.getTable(), (EStructuralFeature)NattablePackage.eINSTANCE.getTable_InvertAxis(), (Object)(!oldValue ? 1 : 0));
            cmd.append((Command)tmp);
            domain.getCommandStack().execute((Command)cmd);
        }
    }

    @Override
    public boolean canInvertAxis() {
        return this.columnManager.canBeUsedAsRowManager() && this.rowManager.canBeUsedAsColumnManager();
    }

    @Override
    public boolean canCreateRowElement(String elementType) {
        return this.rowManager.canCreateAxisElement(elementType);
    }

    @Override
    public boolean canCreateColumnElement(String elementType) {
        return true;
    }

    @Override
    public Command getAddRowElementCommand(Collection<Object> objectsToAdd) {
        boolean addComplementaryAxis;
        EditingDomain domain = this.getContextEditingDomain();
        CompoundCommand cmd = new CompoundCommand(Messages.NattableModelManager_AddRowCommand);
        Command tmp = this.rowManager.getAddAxisCommand(domain, objectsToAdd);
        if (tmp != null) {
            cmd.append(tmp);
        }
        AbstractAxisProvider rowsProvider = AxisUtils.getAxisProviderUsedForRows(this);
        AbstractAxisProvider columnsProvider = AxisUtils.getAxisProviderUsedForColumns(this);
        boolean bl = addComplementaryAxis = rowsProvider instanceof IMasterAxisProvider && columnsProvider instanceof ISlaveAxisProvider && !((IMasterAxisProvider)rowsProvider).isDisconnectSlave();
        if (addComplementaryAxis && (tmp = this.columnManager.getComplementaryAddAxisCommand(domain, objectsToAdd)) != null) {
            cmd.append(tmp);
        }
        return cmd;
    }

    @Override
    public Command getAddColumnElementCommand(Collection<Object> objectsToAdd) {
        boolean addComplementaryAxis;
        EditingDomain domain = this.getContextEditingDomain();
        CompoundCommand cmd = new CompoundCommand(Messages.NattableModelManager_AddColumnCommand);
        Command tmp = this.columnManager.getAddAxisCommand(domain, objectsToAdd);
        if (tmp != null) {
            cmd.append(tmp);
        }
        AbstractAxisProvider rowsProvider = AxisUtils.getAxisProviderUsedForRows(this);
        AbstractAxisProvider columnsProvider = AxisUtils.getAxisProviderUsedForColumns(this);
        boolean bl = addComplementaryAxis = columnsProvider instanceof IMasterAxisProvider && rowsProvider instanceof ISlaveAxisProvider && !((IMasterAxisProvider)columnsProvider).isDisconnectSlave();
        if (addComplementaryAxis && (tmp = this.rowManager.getComplementaryAddAxisCommand(domain, objectsToAdd)) != null) {
            cmd.append(tmp);
        }
        return cmd;
    }

    public Command getDestroyColumnElementCommand(Collection<Object> objectsToDestroy) {
        EditingDomain domain = this.getContextEditingDomain();
        Command cmd = this.columnManager.getDestroyAxisCommand(domain, objectsToDestroy);
        return cmd;
    }

    public Command getDestroyRowElementCommand(Collection<Object> objectsToDestroy) {
        EditingDomain domain = this.getContextEditingDomain();
        Command cmd = this.rowManager.getDestroyAxisCommand(domain, objectsToDestroy);
        return cmd;
    }

    @Override
    public boolean declareEditorsOnColumns() {
        return true;
    }

    @Override
    public boolean declareEditorsOnRows() {
        return false;
    }

    @Override
    public ITableAxisElementProvider getTableAxisElementProvider() {
        return this;
    }

    @Override
    public boolean canCreateDestroyColumnsAxis() {
        return !this.columnManager.isDynamic() && this.columnManager.createPossibleAxisContentProvider(true) != null;
    }

    @Override
    public boolean canCreateDestroyRowsAxis() {
        return !this.rowManager.isDynamic() && this.rowManager.createPossibleAxisContentProvider(true) != null;
    }

    private final void openCreateDestroyAxisManagerDialog(boolean isEditingColumns) {
        ICompositeAxisManager secondAxisManager;
        ICompositeAxisManager editedAxisManager;
        String dialogQuestion;
        String dialogCheckBoxTootip;
        String dialogTitle;
        String checkBoxMessage = Messages.NattableModelManager_DisconnectThisAxisManager;
        if (isEditingColumns) {
            dialogTitle = Messages.NattableModelManager_SelectColumns;
            dialogCheckBoxTootip = Messages.NattableModelManager_DisableTheAutomaticAdditionOfColumnsWhenARowIsAdded;
            dialogQuestion = String.format(Messages.NattableModelManager_TheCheckBoxHasNotBeenCheckedToAvoidAutomaticColumnAddition, checkBoxMessage);
            editedAxisManager = this.columnManager;
            secondAxisManager = this.rowManager;
        } else {
            dialogTitle = Messages.NattableModelManager_SelectRows;
            dialogCheckBoxTootip = Messages.NattableModelManager_DisableTheAutomaticAdditionOfRowsWhenAColumnIsAdded;
            dialogQuestion = String.format(Messages.NattableModelManager_TheCheckBoxHasNotBeenCheckedToAvoidAutomaticRowAddition, checkBoxMessage);
            editedAxisManager = this.rowManager;
            secondAxisManager = this.columnManager;
        }
        LabelProviderService serv = (LabelProviderService)this.natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        ILabelProvider labelProvider = serv.getLabelProvider();
        AbstractAxisProvider editedAxisProvider = editedAxisManager.getRepresentedContentProvider();
        AbstractAxisProvider secondAxisProvider = secondAxisManager.getRepresentedContentProvider();
        ReferenceSelector selector = new ReferenceSelector(true){

            public void createControls(Composite parent) {
                super.createControls(parent);
                this.treeViewer.setComparator(new ViewerComparator((Comparator)new StringComparator()));
            }
        };
        selector.setLabelProvider(labelProvider);
        IRestrictedContentProvider provider = editedAxisManager.createPossibleAxisContentProvider(true);
        if (provider != null) {
            boolean checkboxValue;
            selector.setContentProvider((IStaticContentProvider)new FlattenableRestrictedFilteredContentProvider(provider, selector));
            DisplayedAxisSelectorDialog dialog = new DisplayedAxisSelectorDialog(Display.getDefault().getActiveShell(), (IElementSelector)selector, dialogTitle, true, false, -1);
            boolean displayCheckBox = editedAxisProvider instanceof ISlaveAxisProvider;
            dialog.setDisplayCheckBox(displayCheckBox);
            boolean bl = checkboxValue = secondAxisProvider instanceof IMasterAxisProvider && ((IMasterAxisProvider)secondAxisProvider).isDisconnectSlave();
            if (displayCheckBox) {
                dialog.setCheckBoxValues(checkBoxMessage, dialogCheckBoxTootip, checkboxValue);
            }
            dialog.setInformationDialogValues(Messages.NattableModelManager_DisconnectAxisManagerInformationDialogTitle, dialogQuestion);
            dialog.setLabelProvider(labelProvider);
            dialog.setInitialElementSelections(new ArrayList<Object>(editedAxisManager.getAllManagedAxis()));
            int open = dialog.open();
            if (open == 0) {
                Collection<Object> existingColumns = editedAxisManager.getAllManagedAxis();
                ArrayList<Object> checkedColumns = new ArrayList<Object>();
                checkedColumns.addAll(Arrays.asList(dialog.getResult()));
                ArrayList<Object> columnsToAdd = new ArrayList<Object>(checkedColumns);
                columnsToAdd.removeAll(existingColumns);
                CompoundCommand compoundCommand = new CompoundCommand("Update Existing Axis Command");
                if (columnsToAdd.size() > 0) {
                    Command addAxisElementCommand = null;
                    addAxisElementCommand = isEditingColumns ? this.getAddColumnElementCommand(columnsToAdd) : this.getAddRowElementCommand(columnsToAdd);
                    compoundCommand.append(addAxisElementCommand);
                }
                ArrayList<Object> axisToDestroy = new ArrayList<Object>(existingColumns);
                axisToDestroy.removeAll(checkedColumns);
                if (axisToDestroy.size() > 0) {
                    Command destroyAxisElementCommand = null;
                    destroyAxisElementCommand = isEditingColumns ? this.getDestroyColumnElementCommand(axisToDestroy) : this.getDestroyRowElementCommand(axisToDestroy);
                    compoundCommand.append(destroyAxisElementCommand);
                }
                boolean newState = dialog.isChecked();
                if (displayCheckBox && checkboxValue != newState) {
                    TransactionalEditingDomain domain = (TransactionalEditingDomain)this.getTableEditingDomain();
                    SetRequest request = new SetRequest(domain, (EObject)secondAxisProvider, (EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getIMasterAxisProvider_DisconnectSlave(), (Object)newState);
                    IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((Object)secondAxisProvider);
                    compoundCommand.append((Command)new GMFtoEMFCommandWrapper(commandProvider.getEditCommand((IEditCommandRequest)request)));
                }
                if (!compoundCommand.isEmpty()) {
                    this.getContextEditingDomain().getCommandStack().execute((Command)compoundCommand);
                    this.updateToggleActionState();
                }
            }
        } else {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.NattableModelManager_CreateDestroyAxis, (String)Messages.NattableModelManager_ActionNotYetSupported);
        }
    }

    @Override
    public void openCreateDestroyRowsManagerDialog() {
        this.openCreateDestroyAxisManagerDialog(false);
    }

    @Override
    public void openCreateDestroyColumnsManagerDialog() {
        this.openCreateDestroyAxisManagerDialog(true);
    }

    @Override
    public void sortColumnsByName(boolean alphabeticOrder) {
        this.columnManager.sortAxisByName(alphabeticOrder, this.natTable.getConfigRegistry());
    }

    @Override
    public void sortRowsByName(boolean alphabeticOrder) {
        this.rowManager.sortAxisByName(alphabeticOrder, this.natTable.getConfigRegistry());
    }

    @Override
    public AbstractAxisProvider getVerticalAxisProvider() {
        if (this.getTable().isInvertAxis()) {
            return this.getTable().getCurrentRowAxisProvider();
        }
        return this.getTable().getCurrentColumnAxisProvider();
    }

    @Override
    public AbstractAxisProvider getHorizontalAxisProvider() {
        if (this.getTable().isInvertAxis()) {
            return this.getTable().getCurrentColumnAxisProvider();
        }
        return this.getTable().getCurrentRowAxisProvider();
    }

    @Override
    public boolean canEditColumnHeader(NatEventData evaluationContext) {
        return this.columnManager.canEditAxisHeader(evaluationContext);
    }

    @Override
    public boolean canEditRowHeader(NatEventData evaluationContext) {
        return this.rowManager.canEditAxisHeader(evaluationContext);
    }

    @Override
    public void openEditRowAliasDialog(NatEventData event) {
        this.rowManager.openEditAxisAliasDialog(event, event.getNatTable().getRowIndexByPosition(event.getRowPosition()));
    }

    @Override
    public void openEditColumnAliasDialog(NatEventData event) {
        this.columnManager.openEditAxisAliasDialog(event, event.getNatTable().getColumnIndexByPosition(event.getColumnPosition()));
    }

    @Override
    public IAxisManager getColumnAxisManager() {
        return this.columnManager;
    }

    @Override
    public IAxisManager getRowAxisManager() {
        return this.rowManager;
    }

    @Override
    public void setTableName(String name) {
        SetRequest setNameRequest = new SetRequest((EObject)this.getTable(), (EStructuralFeature)NattableconfigurationPackage.eINSTANCE.getTableNamedElement_Name(), (Object)name);
        IElementEditService editService = ElementEditServiceUtils.getCommandProvider((Object)this.getTable());
        ICommand setNameCommand = editService.getEditCommand((IEditCommandRequest)setNameRequest);
        this.getTableEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(setNameCommand));
    }

    @Override
    public String getTableName() {
        return this.getTable().getName();
    }
}

