/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.manager.table.AbstractNattableWidgetManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.provider.AbstractNattableCellLabelProvider;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderCellContextElement;
import org.eclipse.papyrus.infra.nattable.utils.ILabelProviderContextElement;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElement;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;

public class NattableTopLabelProvider
extends AbstractNattableCellLabelProvider {
    protected String getColumnHeaderLabel(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.getLabel(cell, configRegistry, "org.eclipse.papyrus.infra.nattable.header.labelprovider");
    }

    protected String getRowHeaderLabel(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.getLabel(cell, configRegistry, "org.eclipse.papyrus.infra.nattable.header.labelprovider");
    }

    @Override
    public String getText(Object element) {
        ILayerCell cell = ((ILabelProviderCellContextElement)element).getCell();
        IConfigRegistry configRegistry = ((ILabelProviderContextElement)element).getConfigRegistry();
        String labelProviderContextId = null;
        if (element instanceof IAxis) {
            labelProviderContextId = ((IAxis)element).getManager().getLabelProviderContext();
            return this.getLabel(cell, configRegistry, labelProviderContextId);
        }
        LabelStack labels = this.getLabelStack(cell, configRegistry);
        if (labels.hasLabel("COLUMN_HEADER")) {
            return this.getColumnHeaderLabel(cell, configRegistry);
        }
        if (labels.hasLabel("ROW_HEADER")) {
            return this.getRowHeaderLabel(cell, configRegistry);
        }
        if (labels.hasLabel("BODY")) {
            return this.getBodyLabel(cell, configRegistry);
        }
        Object value = cell.getDataValue();
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    protected LabelStack getLabelStack(ILayerCell cell, IConfigRegistry configRegistry) {
        LabelStack labels = cell.getConfigLabels();
        if (labels.getLabels().isEmpty()) {
            INattableModelManager manager = (INattableModelManager)configRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
            labels = ((AbstractNattableWidgetManager)manager).getGridLayer().getBodyLayer().getConfigLabelsByPosition(cell.getColumnPosition(), cell.getRowPosition());
        }
        return labels;
    }

    protected String getLabel(ILayerCell cell, IConfigRegistry configRegistry, String labelproviderContext) {
        String txt = "";
        Object value = cell.getDataValue();
        LabelProviderCellContextElement contextElement = new LabelProviderCellContextElement(cell, configRegistry);
        LabelProviderService serv = (LabelProviderService)configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        ILabelProvider labelProvider = serv.getLabelProvider(labelproviderContext, (Object)contextElement);
        txt = labelProvider != null ? labelProvider.getText((Object)contextElement) : ((labelProvider = serv.getLabelProvider(labelproviderContext, value)) != null ? labelProvider.getText(value) : ((labelProvider = serv.getLabelProvider(value)) != null ? labelProvider.getText(value) : value.toString()));
        return txt;
    }

    protected String getBodyLabel(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.getLabel(cell, configRegistry, "org.eclipse.papyrus.infra.nattable.body.labelprovider");
    }

    @Override
    public boolean accept(Object element) {
        return element instanceof ILabelProviderCellContextElement;
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof ILabelProviderContextElement) {
            ILayerCell cell = ((ILabelProviderCellContextElement)element).getCell();
            Object object = ((ILabelProviderContextElement)element).getObject();
            String labelProviderContextId = null;
            IConfigRegistry configRegistry = ((ILabelProviderContextElement)element).getConfigRegistry();
            if (object instanceof IAxis) {
                labelProviderContextId = ((IAxis)object).getManager().getLabelProviderContext();
                return this.getImage(cell, configRegistry, labelProviderContextId);
            }
            LabelStack labels = this.getLabelStack(cell, configRegistry);
            if (labels.hasLabel("COLUMN_HEADER")) {
                return this.getColumnHeaderImage(cell, configRegistry);
            }
            if (labels.hasLabel("ROW_HEADER")) {
                return this.getRowHeaderImage(cell, configRegistry);
            }
            if (labels.hasLabel("BODY")) {
                return this.getBodyLabelImage(cell, configRegistry);
            }
        }
        return super.getImage(element);
    }

    private Image getBodyLabelImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return null;
    }

    private Image getRowHeaderImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.getImage(cell, configRegistry, "org.eclipse.papyrus.infra.nattable.header.labelprovider");
    }

    private Image getImage(ILayerCell cell, IConfigRegistry configRegistry, String labelproviderContext) {
        Image image = null;
        Object value = cell.getDataValue();
        LabelProviderCellContextElement contextElement = new LabelProviderCellContextElement(cell, configRegistry);
        LabelProviderService serv = (LabelProviderService)configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        ILabelProvider labelProvider = serv.getLabelProvider(labelproviderContext, (Object)contextElement);
        if (labelProvider != null) {
            image = labelProvider.getImage((Object)contextElement);
        } else {
            labelProvider = serv.getLabelProvider(labelproviderContext, value);
            if (labelProvider != null) {
                image = labelProvider.getImage(value);
            } else {
                labelProvider = serv.getLabelProvider(value);
                if (labelProvider != null) {
                    image = labelProvider.getImage(value);
                }
            }
        }
        return image;
    }

    private Image getColumnHeaderImage(ILayerCell cell, IConfigRegistry configRegistry) {
        return this.getImage(cell, configRegistry, "org.eclipse.papyrus.infra.nattable.header.labelprovider");
    }
}

