/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.ui.services.IDisposable;

public class TableSelectionProvider
implements ISelectionProvider,
IDisposable {
    private SelectionLayer selectionLayer;
    private final ILayerListener selectionListener;
    private ISelection currentSelection;
    private final List<ISelectionChangedListener> listeners;

    public TableSelectionProvider(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
        this.selectionListener = new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                TableSelectionProvider.this.calculateAndStoreNewSelection(event);
            }
        };
        this.selectionLayer.addLayerListener(this.selectionListener);
        this.currentSelection = new StructuredSelection();
        this.listeners = new ArrayList<ISelectionChangedListener>();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void setSelection(ISelection selection) {
        this.currentSelection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection);
        for (ISelectionChangedListener current : this.listeners) {
            current.selectionChanged(event);
        }
    }

    protected void calculateAndStoreNewSelection(ILayerEvent event) {
        if (event instanceof ColumnSelectionEvent) {
            ColumnSelectionEvent e = (ColumnSelectionEvent)event;
            int[] positions = this.selectionLayer.getSelectedColumnPositions();
        } else if (event instanceof CellSelectionEvent) {
            CellSelectionEvent e = (CellSelectionEvent)event;
            int colPos = e.getColumnPosition();
            int rowPos = e.getRowPosition();
            int i = 0;
            ++i;
            ILayerCell cell = this.selectionLayer.getCellByPosition(colPos, rowPos);
            if (cell != null) {
                Object value = cell.getDataValue();
                if (value != null) {
                    if (value instanceof Collection) {
                        ArrayList selection = new ArrayList();
                        for (Object current : (Collection)value) {
                            selection.add(current);
                            this.setSelection((ISelection)new StructuredSelection(selection));
                        }
                    } else {
                        this.setSelection((ISelection)new StructuredSelection(value));
                    }
                } else {
                    this.setSelection((ISelection)new StructuredSelection());
                }
            } else {
                this.setSelection((ISelection)new StructuredSelection());
            }
        }
    }

    public void dispose() {
        this.selectionLayer.removeLayerListener(this.selectionListener);
        this.selectionLayer = null;
    }
}

