/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderContextElement;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;

public class AxisComparator
implements Comparator<IAxis> {
    private boolean alphabeticOrder;
    private IConfigRegistry configRegistry;

    public AxisComparator(boolean alphabticOrder, IConfigRegistry configRegistry) {
        this.alphabeticOrder = alphabticOrder;
        this.configRegistry = configRegistry;
    }

    @Override
    public int compare(IAxis arg0, IAxis arg1) {
        LabelProviderService serv = (LabelProviderService)this.configRegistry.getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"label_provider_service_id"});
        Object element0 = arg0.getElement();
        Object element1 = arg1.getElement();
        String str1 = this.getText(serv, element0).replaceAll("[^\\w\\s]", "");
        String str2 = this.getText(serv, element1).replaceAll("[^\\w\\s]", "");
        if (this.alphabeticOrder) {
            return str1.compareToIgnoreCase(str2);
        }
        return str2.compareToIgnoreCase(str1);
    }

    protected String getText(LabelProviderService serv, Object obj) {
        ILabelProvider provider = serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.header.labelprovider");
        return provider.getText((Object)new LabelProviderContextElement(obj, this.configRegistry));
    }
}

