/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.modelelement;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.creation.StyleSheetFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.DiagramStyleSheetObservableList;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.provider.CSSStyleSheetContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.provider.CSSStyleSheetLabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.CSSClassContentProvider;
import org.eclipse.papyrus.infra.gmfdiag.properties.modelelement.CustomStyleModelElement;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.creation.StringEditionFactory;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;

public class CSSModelElement
extends CustomStyleModelElement {
    public CSSModelElement(View source, DataContextElement context) {
        super(source, context);
    }

    public CSSModelElement(View source, EditingDomain domain, DataContextElement element) {
        super(source, domain, element);
    }

    public ReferenceValueFactory getValueFactory(String propertyPath) {
        if ("css_stylesheets".equals(propertyPath)) {
            return new StyleSheetFactory((View)this.source);
        }
        if ("cssClass".equals(propertyPath)) {
            StringEditionFactory factory = new StringEditionFactory();
            factory.setContentProvider(this.getContentProvider(propertyPath));
            return factory;
        }
        return super.getValueFactory(propertyPath);
    }

    public IObservable doGetObservable(String propertyPath) {
        if ("css_stylesheets".equals(propertyPath)) {
            return new DiagramStyleSheetObservableList((View)this.source, this.domain, propertyPath);
        }
        return super.doGetObservable(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if ("css_stylesheets".equals(propertyPath)) {
            return new CSSStyleSheetLabelProvider();
        }
        return super.getLabelProvider(propertyPath);
    }

    public IStaticContentProvider getContentProvider(String propertyPath) {
        if (propertyPath.equals("css_stylesheets")) {
            return new CSSStyleSheetContentProvider(this.source);
        }
        if (propertyPath.equals("cssClass")) {
            EObject semanticElement;
            Diagram diagram = ((View)this.source).getDiagram();
            if (diagram instanceof CSSDiagram && (semanticElement = ((View)this.source).getElement()) != null) {
                String elementName = this.source instanceof Diagram ? "*" : semanticElement.eClass().getName();
                return new CSSClassContentProvider(elementName, ((CSSDiagram)diagram).getEngine());
            }
            return null;
        }
        return null;
    }
}

