/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.axis;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class EObjectAxisManager
extends AbstractAxisManager {
    public Command getAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        CompoundCommand cmd = new CompoundCommand(Messages.EObjectManager_AddAxisElement);
        for (Object object : objectToAdd) {
            if (!this.isAllowedContents(object)) continue;
            EObjectAxis horizontalAxis = NattableaxisFactory.eINSTANCE.createEObjectAxis();
            horizontalAxis.setElement((EObject)object);
            horizontalAxis.setManager(this.representedAxisManager);
            Command tmp = AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), (Object)horizontalAxis);
            cmd.append(tmp);
        }
        return cmd;
    }

    public Command getComplementaryAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        return null;
    }

    public boolean isAllowedContents(Object object) {
        boolean isAllowed = super.isAllowedContents(object);
        if (isAllowed) {
            return object instanceof EObject;
        }
        return false;
    }

    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        for (Object object : objectsToAdd) {
            if (!this.isAllowedContents(object)) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isSlave() {
        return false;
    }

    public boolean canEditAxisHeader() {
        return false;
    }

    public String getElementAxisName(IAxis axis) {
        throw new UnsupportedOperationException();
    }

    public boolean canDestroyAxisElement(IAxis axis) {
        EObject object = (EObject)axis.getElement();
        return !EMFHelper.isReadOnly((EObject)object);
    }

    public boolean canDestroyAxisElement(Integer axisPosition) {
        Object current = this.getElements().get(axisPosition);
        if (current instanceof EObjectAxis) {
            return !EMFHelper.isReadOnly((EObject)((EObjectAxis)current).getElement());
        }
        return false;
    }

    public Command getDestroyAxisElementCommand(EditingDomain domain, Integer axisPosition) {
        Object current = this.getElements().get(axisPosition);
        if (current instanceof EObjectAxis) {
            EObject element = ((EObjectAxis)current).getElement();
            DestroyElementRequest request = new DestroyElementRequest((TransactionalEditingDomain)this.getContextEditingDomain(), element, false);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)element);
            return new GMFtoEMFCommandWrapper(provider.getEditCommand((IEditCommandRequest)request));
        }
        return null;
    }
}

