/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class EStructuralFeatureAxisManager
extends AbstractAxisManager {
    public Command getComplementaryAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        HashSet<Object> features = new HashSet<Object>();
        for (Object current : objectToAdd) {
            if (!(current instanceof EObject)) continue;
            features.addAll((Collection<Object>)((EObject)current).eClass().getEAllStructuralFeatures());
        }
        features.removeAll(this.getTableManager().getElementsList(this.getRepresentedContentProvider()));
        if (!features.isEmpty()) {
            return this.getAddAxisCommand(domain, features);
        }
        return null;
    }

    public Command getAddAxisCommand(EditingDomain domain, Collection<Object> objectToAdd) {
        ArrayList<EStructuralFeatureAxis> toAdd = new ArrayList<EStructuralFeatureAxis>();
        for (Object current : objectToAdd) {
            if (!this.isAllowedContents(current)) continue;
            EStructuralFeatureAxis newAxis = NattableaxisFactory.eINSTANCE.createEStructuralFeatureAxis();
            newAxis.setElement((EStructuralFeature)current);
            newAxis.setManager(this.representedAxisManager);
            toAdd.add(newAxis);
        }
        if (!toAdd.isEmpty()) {
            return AddCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), toAdd);
        }
        return null;
    }

    public Command getDestroyAxisCommand(EditingDomain domain, Collection<Object> objectToDestroy) {
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getRepresentedContentProvider());
        CompositeCommand compositeCommand = new CompositeCommand("Destroy IAxis Command");
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            if (current.getManager() != this.representedAxisManager || !objectToDestroy.contains(current) && !objectToDestroy.contains(current.getElement())) continue;
            DestroyElementRequest request = new DestroyElementRequest((TransactionalEditingDomain)domain, (EObject)current, false);
            compositeCommand.add((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)request));
        }
        if (!compositeCommand.isEmpty()) {
            return new GMFtoEMFCommandWrapper((ICommand)compositeCommand);
        }
        return null;
    }

    public boolean isAllowedContents(Object object) {
        boolean isAllowed = super.isAllowedContents(object);
        if (isAllowed) {
            return object instanceof EStructuralFeature;
        }
        return false;
    }

    public boolean canInsertAxis(Collection<Object> objectsToAdd, int index) {
        return false;
    }

    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        for (Object object : objectsToAdd) {
            if (!this.isAllowedContents(object)) continue;
            return true;
        }
        return false;
    }

    public Collection<Object> getAllPossibleAxis() {
        HashSet<Object> objects = new HashSet<Object>();
        for (Object current : this.getAllManagedAxis()) {
            EClass eClass = (EClass)current;
            EPackage ePackage = eClass.getEPackage();
            if (eClass.getEStructuralFeatures().isEmpty()) continue;
            objects.add(ePackage);
        }
        return objects;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isSlave() {
        return true;
    }

    public boolean canEditAxisHeader() {
        return true;
    }

    public String getElementAxisName(IAxis axis) {
        if (axis instanceof EStructuralFeatureAxis) {
            return ((EStructuralFeatureAxis)axis).getElement().getName();
        }
        return null;
    }

    public boolean canDestroyAxisElement(IAxis axis) {
        EObject object = (EObject)axis.getElement();
        return !EMFHelper.isReadOnly((EObject)object);
    }

    public boolean canDestroyAxisElement(Integer axisPosition) {
        return false;
    }

    public Command getDestroyAxisElementCommand(EditingDomain domain, Integer axisPosition) {
        return UnexecutableCommand.INSTANCE;
    }
}

