/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.manager.cell;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class EMFFeatureValueCellManager
extends AbstractCellManager {
    public boolean handles(Object obj1, Object obj2) {
        return this.organizeObject(obj1, obj2).size() == 2;
    }

    public Object getValue(Object obj1, Object obj2) {
        List<EObject> objects = this.organizeObject(obj1, obj2);
        EObject eobject = objects.get(0);
        EStructuralFeature feature = (EStructuralFeature)objects.get(1);
        if (eobject.eClass().getEAllStructuralFeatures().contains((Object)feature)) {
            return eobject.eGet(feature);
        }
        return NOT_AVALAIBLE;
    }

    protected List<EObject> organizeObject(Object obj1, Object obj2) {
        if (obj1 instanceof IAxis) {
            obj1 = ((IAxis)obj1).getElement();
        }
        if (obj2 instanceof IAxis) {
            obj2 = ((IAxis)obj2).getElement();
        }
        ArrayList<EObject> objects = new ArrayList<EObject>();
        if (obj1 instanceof EObject && obj2 instanceof EStructuralFeature) {
            objects.add((EObject)obj1);
            objects.add((EObject)obj2);
        } else if (obj1 instanceof EStructuralFeature && obj2 instanceof EObject) {
            objects.add((EObject)obj2);
            objects.add((EObject)obj1);
        }
        return objects;
    }

    public boolean isCellEditable(Object obj1, Object obj2) {
        List<EObject> objects = this.organizeObject(obj1, obj2);
        if (objects.size() == 2) {
            EObject object = objects.get(0);
            EStructuralFeature feature = (EStructuralFeature)objects.get(1);
            if (object.eClass().getEAllStructuralFeatures().contains((Object)feature) && !feature.isDerived()) {
                return true;
            }
        }
        return false;
    }

    public Command getSetValueCommand(EditingDomain domain, Object rowElement, Object lineElement, Object newValue) {
        List<EObject> objects = this.organizeObject(rowElement, lineElement);
        SetRequest request = new SetRequest((TransactionalEditingDomain)domain, objects.get(0), (EStructuralFeature)objects.get(1), newValue);
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)objects.get(0));
        return new GMFtoEMFCommandWrapper(provider.getEditCommand((IEditCommandRequest)request));
    }

    public boolean handlesAxisElement(Object obj) {
        return obj instanceof EStructuralFeature || obj instanceof EStructuralFeatureAxis;
    }
}

