/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.views.config.manager.axis;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageList;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractSynchronizedOnFeatureAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.cell.CellManagerFactory;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.views.config.utils.Utils;

public class EditorContextSynchronizerAxisManager
extends AbstractSynchronizedOnFeatureAxisManager {
    private PageList pageList;

    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        super.init(manager, rep, provider);
    }

    protected void addContextFeatureValueListener() {
        this.featureListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == DiPackage.eINSTANCE.getPageList_AvailablePage()) {
                    EditorContextSynchronizerAxisManager.this.getTableManager().updateAxisContents(EditorContextSynchronizerAxisManager.this.getRepresentedContentProvider());
                }
            }
        };
        this.getPageList().eAdapters().add((Object)this.featureListener);
    }

    private PageList getPageList() {
        if (this.pageList == null) {
            this.pageList = Utils.getPageList(this.getTableManager().getTable());
        }
        return this.pageList;
    }

    protected void verifyCoupleContextFeature() {
    }

    private boolean mustBeDisplayedInThisTable(Object page) {
        Object value = CellManagerFactory.INSTANCE.getCrossValue(page, (Object)"nattable_editor_pages:/context");
        if (value instanceof EObject) {
            EObject tableContext = this.getTableContext();
            EObject container = (EObject)value;
            while (container != null) {
                if (container == tableContext) {
                    return true;
                }
                container = container.eContainer();
            }
        }
        return false;
    }

    public void dispose() {
        if (this.getPageList() != null) {
            this.getPageList().eAdapters().remove((Object)this.featureListener);
        }
        this.pageList = null;
        super.dispose();
    }

    public Collection<Object> getAllManagedAxis() {
        PageList pageList = Utils.getPageList(this.getTableManager().getTable());
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.clear();
        for (PageRef ref : pageList.getAvailablePage()) {
            Object page = ref.getPageIdentifier();
            if (!this.mustBeDisplayedInThisTable(page)) continue;
            elements.add(page);
        }
        return elements;
    }

    public boolean canEditAxisHeader() {
        return false;
    }

    public boolean canDestroyAxisElement(Integer axisPosition) {
        return false;
    }

    public Command getDestroyAxisElementCommand(EditingDomain domain, Integer axisPosition) {
        return UnexecutableCommand.INSTANCE;
    }
}

