/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.views.config.manager.cell;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.nattable.manager.cell.AbstractCellManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.views.config.Activator;
import org.eclipse.papyrus.infra.nattable.views.config.utils.Utils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;

public class ModelViewsCellManager
extends AbstractCellManager {
    private static final String DIAGRAM_CONTEXT_FEATURE_NAME = "element";
    private static final String PAPYRUS_TABLE_INSTANCE__TABLE_INSTANCE2_FEATURE_NAME = "table";

    protected List<Object> organizeObject(Object obj1, Object obj2) {
        IPageManager mngr;
        Object first;
        ArrayList<Object> objects = new ArrayList<Object>();
        if (obj1 instanceof String && ((String)obj1).startsWith("nattable_editor_pages:/")) {
            objects.add(obj2);
            objects.add(obj1);
        } else if (obj2 instanceof String && ((String)obj2).startsWith("nattable_editor_pages:/")) {
            objects.add(obj1);
            objects.add(obj2);
        }
        if (objects.size() == 2 && (first = objects.get(0)) instanceof EObject && (mngr = Utils.getIPagneManager((EObject)first)) != null && !mngr.allPages().contains(first)) {
            return Collections.emptyList();
        }
        return objects;
    }

    public boolean handles(Object obj1, Object obj2) {
        return this.organizeObject(obj1, obj2).size() == 2;
    }

    public boolean handlesAxisElement(Object obj) {
        return false;
    }

    public Object getValue(Object obj1, Object obj2) {
        List<Object> objects = this.organizeObject(obj1, obj2);
        String featureName = ((String)objects.get(1)).replace("nattable_editor_pages:/", "");
        Object editor = objects.get(0);
        if ("name".equals(featureName)) {
            return this.getEditorName(editor);
        }
        if ("context".equals(featureName)) {
            return this.getEditorContext(editor);
        }
        if ("isOpen".equals(featureName)) {
            return this.getEditorIsOpen(editor);
        }
        if ("type".equals(featureName)) {
            return this.getEditorType(editor);
        }
        return NOT_AVALAIBLE;
    }

    public boolean isCellEditable(Object obj1, Object obj2) {
        List<Object> objects = this.organizeObject(obj1, obj2);
        String featureName = ((String)objects.get(1)).replace("nattable_editor_pages:/", "");
        return featureName.equals("name");
    }

    public Command getSetValueCommand(EditingDomain domain, Object obj1, Object obj2, Object newValue) {
        List<Object> objects = this.organizeObject(obj1, obj2);
        if (objects.get(0) instanceof EObject) {
            EObject editor = (EObject)objects.get(0);
            String featureName = ((String)objects.get(1)).replace("nattable_editor_pages:/", "");
            if ("name".equals(featureName)) {
                EStructuralFeature feature = editor.eClass().getEStructuralFeature("name");
                SetRequest request = new SetRequest((TransactionalEditingDomain)domain, editor, feature, newValue);
                IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)editor);
                return new GMFtoEMFCommandWrapper(provider.getEditCommand((IEditCommandRequest)request));
            }
        }
        return null;
    }

    protected Object getEditorType(Object editor) {
        if (editor instanceof EObject) {
            if (editor instanceof Table) {
                return ((Table)editor).getTableConfiguration().getType();
            }
            EStructuralFeature feature = ((EObject)editor).eClass().getEStructuralFeature("type");
            if (feature != null) {
                return ((EObject)editor).eGet(feature);
            }
        }
        return NOT_AVALAIBLE;
    }

    protected Object getEditorIsOpen(Object editor) {
        if (editor instanceof EObject) {
            IPageManager mngr = null;
            try {
                mngr = ServiceUtilsForResource.getInstance().getIPageManager((Object)((EObject)editor).eResource());
                return mngr.isOpen(editor);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return NOT_AVALAIBLE;
    }

    protected Object getEditorName(Object editor) {
        EObject eobject;
        EStructuralFeature feature;
        if (editor instanceof EObject && editor instanceof EObject && (feature = (eobject = (EObject)editor).eClass().getEStructuralFeature("name")) != null) {
            return eobject.eGet(feature);
        }
        return NOT_AVALAIBLE;
    }

    protected Object getEditorContext(Object editor) {
        if (editor instanceof EObject) {
            EObject tableinstance2;
            EObject eobject = (EObject)editor;
            EStructuralFeature feature = eobject.eClass().getEStructuralFeature("context");
            if (feature == null) {
                feature = eobject.eClass().getEStructuralFeature(DIAGRAM_CONTEXT_FEATURE_NAME);
            }
            if (feature != null) {
                return eobject.eGet(feature);
            }
            EStructuralFeature tmp = eobject.eClass().getEStructuralFeature(PAPYRUS_TABLE_INSTANCE__TABLE_INSTANCE2_FEATURE_NAME);
            if (tmp != null && (tableinstance2 = (EObject)eobject.eGet(tmp)) != null) {
                feature = tableinstance2.eClass().getEStructuralFeature("context");
                return tableinstance2.eGet(feature);
            }
        }
        return NOT_AVALAIBLE;
    }
}

