/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.views.config.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageList;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.views.config.Activator;

public class Utils {
    public static final String NATTABLE_EDITOR_PAGE_ID = "nattable_editor_pages:/";
    public static final String VIEW_NAME = "name";
    public static final String VIEW_CONTEXT = "context";
    public static final String VIEW_IS_OPEN = "isOpen";
    public static final String VIEW_EDITOR_TYPE = "type";
    public static final String TABLE_VIEW_TYPE_VALUE = "PapyrusTableViewsEditor";

    private Utils() {
    }

    public static final PageList getPageList(Table table) {
        Resource resource = table.eResource();
        ModelSet modelSet = (ModelSet)resource.getResourceSet();
        Resource diResource = modelSet.getAssociatedResource(resource, "di", false);
        SashWindowsMngr windowMngr = DiUtils.lookupSashWindowsMngr((Resource)diResource);
        PageList pageList = windowMngr.getPageList();
        assert (pageList != null);
        return pageList;
    }

    public static final IPageManager getIPagneManager(EObject eobject) {
        IPageManager mngr = null;
        try {
            mngr = ServiceUtilsForResource.getInstance().getIPageManager((Object)eobject.eResource());
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return mngr;
    }
}

