/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.ui.contributions;

import com.google.inject.Injector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.PopupEditorConfiguration;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.edit.part.IXTextSemanticValidator;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.edit.part.IXtextEMFReconciler;
import org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.constraintWithVSLl.ConstraintRule;
import org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.constraintWithVSLl.ConstraintSpecification;
import org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.ui.internal.ConstraintWithVSLlActivator;
import org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.validation.ConstraintWithVSLlJavaValidator;
import org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.validation.SemanticValidator;
import org.eclipse.papyrus.marte.vsl.extensions.VSLSerializationUtil;
import org.eclipse.papyrus.marte.vsl.vSL.Expression;
import org.eclipse.papyrus.marte.vsl.validation.VSLJavaValidator;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;

public class ConstraintWithVSLPopupEditorConfiguration
extends PopupEditorConfiguration {
    private Constraint constraint = null;
    private String newBody = "";

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Constraint) {
            Constraint theConstraint = (Constraint)editedObject;
            if (theConstraint.getSpecification() != null && theConstraint.getSpecification() instanceof OpaqueExpression) {
                OpaqueExpression spec = (OpaqueExpression)theConstraint.getSpecification();
                int indexOfVSLExpression = -1;
                int i = 0;
                for (String language : spec.getLanguages()) {
                    if (language.equals("VSL")) {
                        indexOfVSLExpression = i;
                    }
                    ++i;
                }
                return indexOfVSLExpression != -1 ? (String)spec.getBodies().get(indexOfVSLExpression) : "";
            }
            return "";
        }
        return "Not a Constraint";
    }

    public IPopupEditorHelper createPopupEditorHelper(Object editPart) {
        IGraphicalEditPart graphicalEditPart = null;
        if (!(editPart instanceof IGraphicalEditPart)) {
            return null;
        }
        graphicalEditPart = (IGraphicalEditPart)editPart;
        if (!(graphicalEditPart.resolveSemanticElement() instanceof Constraint)) {
            return null;
        }
        this.constraint = (Constraint)graphicalEditPart.resolveSemanticElement();
        ConstraintWithVSLlJavaValidator.init((Element)this.constraint);
        VSLJavaValidator.init((Element)this.constraint);
        Injector injector = ConstraintWithVSLlActivator.getInstance().getInjector("org.eclipse.papyrus.marte.textedit.constraintwithvsl.xtext.ConstraintWithVSLl");
        String textToEdit = this.getTextToEdit(graphicalEditPart.resolveSemanticElement());
        String fileExtension = ".constraintwithvsl";
        IXtextEMFReconciler reconciler = new IXtextEMFReconciler(){

            public void reconcile(EObject modelObject, EObject xtextObject) {
                ConstraintSpecification newSpecification = null;
                ConstraintRule rule = (ConstraintRule)xtextObject;
                newSpecification = rule.getSpecification();
                if (newSpecification != null) {
                    ConstraintWithVSLPopupEditorConfiguration.this.newBody = VSLSerializationUtil.printExpression((Expression)newSpecification.getExpression());
                }
                UpdateConstraintWithVSLCommand updateCommand = new UpdateConstraintWithVSLCommand(ConstraintWithVSLPopupEditorConfiguration.this.constraint);
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)updateCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    System.out.println((Object)e);
                }
            }
        };
        return super.createPopupEditorHelper(graphicalEditPart, injector, reconciler, textToEdit, fileExtension, (IXTextSemanticValidator)new SemanticValidator());
    }

    private CompositeCommand getUpdateCommand(EObject editedObject) {
        CompositeCommand updateCommand = new CompositeCommand("Property update");
        return updateCommand;
    }

    protected class UpdateConstraintWithVSLCommand
    extends AbstractTransactionalCommand {
        private Constraint theConstraint;

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            this.theConstraint.setSpecification(null);
            OpaqueExpression opaqueExp = UMLFactory.eINSTANCE.createOpaqueExpression();
            opaqueExp.getLanguages().add((Object)"VSL");
            opaqueExp.getBodies().add((Object)ConstraintWithVSLPopupEditorConfiguration.this.newBody);
            this.theConstraint.setSpecification((ValueSpecification)opaqueExp);
            return CommandResult.newOKCommandResult((Object)this.theConstraint);
        }

        public UpdateConstraintWithVSLCommand(Constraint constraint) {
            super(EditorUtils.getTransactionalEditingDomain(), "Constraint Update", UpdateConstraintWithVSLCommand.getWorkspaceFiles((EObject)constraint));
            this.theConstraint = constraint;
        }
    }
}

