/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layout;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.layout.Activator;
import org.eclipse.papyrus.layout.LayoutTool;
import org.eclipse.papyrus.layout.LayoutToolAlgorithms;
import org.eclipse.papyrus.layout.LayoutToolExtensionPointManager;
import org.eclipse.papyrus.layout.managealgorithms.ZestAlgortihms;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutToolToolbar
extends ContributionItem {
    private static Image imageLayout = null;
    private ISelection theSelection;
    private Collection<LayoutToolAlgorithms> algorithmes = ZestAlgortihms.getRegisteredAlgorithmes();
    private Menu menu = null;
    private LayoutToolAlgorithms currentAlgorithm;
    private ToolBar toolbar;
    private ToolItem itemForMenu;
    private ToolItem itemDropDown;
    private ToolTip currentToolTip = null;
    private String itemLayoutText = "Add layout area";
    private String layoutToolTipText = "Draw a layout area resizable around nodes, algorithms will be apply to this area";
    private ToolTip layoutToolTip = null;

    static {
        try {
            imageLayout = new Image((Device)Display.getDefault(), Activator.getDefault().getBundle().getEntry("icons/layoutIcon.gif").openStream());
        }
        catch (IOException e) {
            Activator.getDefault().log("Cannot load layoutIcon", e);
        }
    }

    public LayoutToolToolbar() {
        this("LayoutToolToolbar");
    }

    public LayoutToolToolbar(String id) {
        super(id);
    }

    public void fill(final ToolBar toolBar, int index) {
        this.toolbar = toolBar;
        this.itemDropDown = new ToolItem(toolBar, 4);
        if (this.currentAlgorithm == null) {
            this.itemDropDown.setImage(imageLayout);
        } else {
            this.itemDropDown.setImage(this.currentAlgorithm.getIcon());
        }
        this.itemDropDown.setText("");
        this.getMenu((Control)toolBar);
        this.itemDropDown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LayoutToolToolbar.this.getMenu((Control)LayoutToolToolbar.this.toolbar);
                if (event.detail == 4) {
                    Rectangle bounds = LayoutToolToolbar.this.itemDropDown.getBounds();
                    Point point = toolBar.toDisplay(bounds.x, bounds.y + bounds.height);
                    LayoutToolToolbar.this.menu.setLocation(point);
                    LayoutToolToolbar.this.menu.setVisible(true);
                }
            }
        });
        Listener selectionListener = new Listener(){

            public void handleEvent(Event event) {
                LayoutToolToolbar.this.getSelection();
                if (LayoutToolToolbar.this.currentAlgorithm == null && event.y == 0 && LayoutToolToolbar.this.itemForMenu.getData() != null && LayoutToolToolbar.this.itemForMenu.getData().equals(LayoutToolToolbar.this.itemLayoutText)) {
                    LayoutToolToolbar.this.createLayoutArea();
                }
                if (LayoutToolToolbar.this.hasElementsSelected()) {
                    if (event.y == 0 && LayoutToolToolbar.this.currentAlgorithm != null) {
                        LayoutToolToolbar.this.callAlgorithm();
                    }
                    MenuItem[] menuItemArray = LayoutToolToolbar.this.menu.getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem menuItem = menuItemArray[n2];
                        menuItem.setEnabled(true);
                        ++n2;
                    }
                } else {
                    MenuItem[] menuItemArray = LayoutToolToolbar.this.menu.getItems();
                    int n = menuItemArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        MenuItem menuItem = menuItemArray[n3];
                        if (!menuItem.getText().equals(LayoutToolToolbar.this.itemLayoutText)) {
                            menuItem.setEnabled(false);
                        }
                        ++n3;
                    }
                }
            }
        };
        this.itemDropDown.addListener(13, selectionListener);
    }

    public Menu getMenu(Control parent) {
        this.menu = new Menu(parent);
        this.insertIntoMenuAlgorithms();
        if (this.menu.getItems().length > 0 && parent instanceof ToolBar) {
            this.toolbar = (ToolBar)parent;
            if (this.toolbar.getItems().length == 1) {
                this.itemForMenu = this.toolbar.getItem(0);
            }
        }
        this.createLayoutAreaIcon();
        return this.menu;
    }

    private void insertIntoMenuAlgorithms() {
        if (this.algorithmes == null || this.algorithmes.isEmpty()) {
            Activator.getDefault().log("Algorithms not found");
            return;
        }
        HashMap<String, Menu> mapMenuPath = new HashMap<String, Menu>();
        for (LayoutToolAlgorithms a : this.algorithmes) {
            Menu submenu = this.menu;
            if (a.getPath() != null) {
                String[] pathSplit = a.getPath().split("\\.");
                String subString = "";
                int i = 0;
                while (i < pathSplit.length) {
                    subString = String.valueOf(subString) + pathSplit[i];
                    if (!mapMenuPath.keySet().contains(subString)) {
                        MenuItem itemPath = new MenuItem(submenu, 64);
                        itemPath.setText(pathSplit[i]);
                        submenu = new Menu(submenu);
                        itemPath.setMenu(submenu);
                        mapMenuPath.put(subString, submenu);
                    } else {
                        for (String path : mapMenuPath.keySet()) {
                            if (!subString.equals(path)) continue;
                            submenu = (Menu)mapMenuPath.get(path);
                        }
                    }
                    subString = String.valueOf(subString) + ".";
                    ++i;
                }
            }
            final MenuItem item = new MenuItem(submenu, 16);
            item.setText(a.getName());
            item.setImage(a.getIcon());
            item.setData((Object)a);
            if (a.getToolTipText() != null) {
                final ToolTip toolTip = new ToolTip(this.menu.getShell(), 0);
                toolTip.setText(item.getText());
                toolTip.setMessage(((LayoutToolAlgorithms)item.getData()).getToolTipText());
                item.addListener(30, new Listener(){

                    public void handleEvent(Event event) {
                        if (LayoutToolToolbar.this.currentToolTip != null) {
                            LayoutToolToolbar.this.currentToolTip.setVisible(false);
                        }
                        if (LayoutToolToolbar.this.layoutToolTip != null) {
                            LayoutToolToolbar.this.layoutToolTip.setVisible(false);
                        }
                        LayoutToolToolbar.this.currentToolTip = toolTip;
                        Point mouse = Display.getDefault().getCursorLocation();
                        int x = mouse.x + 20;
                        int y = mouse.y + 30;
                        toolTip.setLocation(new Point(x, y));
                        toolTip.setVisible(true);
                    }
                });
            } else {
                item.addListener(30, new Listener(){

                    public void handleEvent(Event event) {
                        if (LayoutToolToolbar.this.currentToolTip != null) {
                            LayoutToolToolbar.this.currentToolTip.setVisible(false);
                            LayoutToolToolbar.this.currentToolTip = null;
                        }
                        if (LayoutToolToolbar.this.layoutToolTip != null) {
                            LayoutToolToolbar.this.layoutToolTip.setVisible(false);
                        }
                    }
                });
            }
            item.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (((MenuItem)e.getSource()).getSelection()) {
                        if (LayoutToolToolbar.this.currentToolTip != null) {
                            LayoutToolToolbar.this.currentToolTip.setVisible(false);
                        }
                        LayoutToolToolbar.this.handleSelected(e, item);
                    }
                }
            });
        }
    }

    private void handleSelected(SelectionEvent e, MenuItem item) {
        LayoutToolAlgorithms layoutToolAlgorithms = (LayoutToolAlgorithms)item.getData();
        if (this.itemForMenu != null) {
            this.itemForMenu.setImage(layoutToolAlgorithms.getIcon());
            if (layoutToolAlgorithms.getToolTipText() != null) {
                this.itemForMenu.setToolTipText(layoutToolAlgorithms.getToolTipText());
            } else {
                this.itemForMenu.setToolTipText(null);
            }
        }
        this.currentAlgorithm = layoutToolAlgorithms;
        this.callAlgorithm();
    }

    public void dispose() {
    }

    public void run(IAction action) {
        this.callAlgorithm();
    }

    private void callAlgorithm() {
        if (this.currentAlgorithm == null) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warning", (String)"Please choose an algorithm");
            return;
        }
        LayoutTool.getInstance().applyLayout(this.currentAlgorithm.getName(), this.getEditPartSelected());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.theSelection = selection;
    }

    public ISelection getSelection() {
        this.theSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite().getSelectionProvider().getSelection();
        return this.theSelection;
    }

    public List<EditPart> getEditPartSelected() {
        ArrayList<EditPart> editParts = new ArrayList<EditPart>();
        if (this.theSelection instanceof IStructuredSelection) {
            IStructuredSelection selec = (IStructuredSelection)this.theSelection;
            List objects = selec.toList();
            for (Object iter : objects) {
                if (!(iter instanceof EditPart)) continue;
                EditPart e = (EditPart)iter;
                editParts.add(e);
            }
        }
        LayoutToolToolbar.sort(editParts);
        return editParts;
    }

    public static void sort(List<EditPart> editParts) {
        Collections.sort(editParts, new Comparator<EditPart>(){

            @Override
            public int compare(EditPart arg0, EditPart arg1) {
                return LayoutToolToolbar.getNbParents(arg0) - LayoutToolToolbar.getNbParents(arg1);
            }
        });
    }

    private static int getNbParents(EditPart part) {
        int result = 0;
        EditPart tmp = part;
        while (tmp.getParent() != null) {
            ++result;
            tmp = tmp.getParent();
        }
        return result;
    }

    private boolean hasElementsSelected() {
        List<EditPart> l = this.getEditPartSelected();
        return l.size() > 1;
    }

    private void createLayoutArea() {
        LayoutToolExtensionPointManager.getInstance().getLayoutAreaCreator().paintLayoutArea();
    }

    private void createLayoutAreaIcon() {
        if (LayoutToolExtensionPointManager.getInstance().getLayoutAreaCreator() != null) {
            new MenuItem(this.menu, 2);
            final MenuItem itemLayout = new MenuItem(this.menu, 8);
            itemLayout.setText(this.itemLayoutText);
            try {
                itemLayout.setImage(new Image((Device)Display.getDefault(), Activator.getDefault().getBundle().getEntry("icons/layout_area.gif").openStream()));
            }
            catch (IOException e) {
                Activator.getDefault().log("Cannot load layout area icon", e);
            }
            this.layoutToolTip = new ToolTip(this.menu.getShell(), 0);
            itemLayout.addListener(30, new Listener(){

                public void handleEvent(Event event) {
                    if (LayoutToolToolbar.this.currentToolTip != null) {
                        LayoutToolToolbar.this.currentToolTip.setVisible(false);
                    }
                    LayoutToolToolbar.this.layoutToolTip.setText(itemLayout.getText());
                    LayoutToolToolbar.this.layoutToolTip.setMessage(LayoutToolToolbar.this.layoutToolTipText);
                    LayoutToolToolbar.this.layoutToolTip.setVisible(true);
                    Point mouse = Display.getDefault().getCursorLocation();
                    int x = mouse.x + 20;
                    int y = mouse.y + 30;
                    LayoutToolToolbar.this.layoutToolTip.setLocation(new Point(x, y));
                }
            });
            itemLayout.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (LayoutToolToolbar.this.layoutToolTip != null) {
                        LayoutToolToolbar.this.layoutToolTip.setVisible(false);
                    }
                    LayoutToolToolbar.this.createLayoutArea();
                    LayoutToolToolbar.this.currentAlgorithm = null;
                    LayoutToolToolbar.this.itemForMenu.setImage(itemLayout.getImage());
                    LayoutToolToolbar.this.itemForMenu.setData((Object)LayoutToolToolbar.this.itemLayoutText);
                    LayoutToolToolbar.this.itemForMenu.setToolTipText(LayoutToolToolbar.this.layoutToolTipText);
                }
            });
        }
    }
}

