/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.papyrus.layout.Activator;
import org.eclipse.papyrus.layout.LayoutToolExtensionPointManager;
import org.eclipse.papyrus.layout.LayouttoolInterface;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayouttoolController {
    private LayouttoolInterface subEditor;
    private List<EditPart> listEditPartSelected;
    private LayoutAlgorithm currentLayoutAlgorithm;
    private List<SimpleNode> listNodes = new ArrayList<SimpleNode>();
    private List<EditPart> listNodesEditPart = new ArrayList<EditPart>();
    private List<SimpleRelationship> listRelationships = new ArrayList<SimpleRelationship>();

    public LayouttoolController(List<EditPart> list, AbstractLayoutAlgorithm currentAlgorithm) {
        this.listEditPartSelected = list;
        this.currentLayoutAlgorithm = currentAlgorithm;
    }

    public void execute() {
        this.subEditor = LayoutToolExtensionPointManager.getInstance().getSubEditor();
        if (this.subEditor == null) {
            Activator.getDefault().log("Editor not found");
            return;
        }
        if (this.listEditPartSelected == null || this.listEditPartSelected.size() <= 1) {
            Activator.getDefault().log("Select at least two elements");
            return;
        }
        this.createNodes();
        if (this.listNodes == null || this.listNodes.size() <= 1) {
            Activator.getDefault().log("Any node selected");
            return;
        }
        this.createRelationships();
        EditPart[] arrayEditPart = new EditPart[this.listEditPartSelected.size()];
        this.listEditPartSelected.toArray(arrayEditPart);
        Rectangle layoutArea = this.subEditor.getLayoutArea(arrayEditPart);
        SimpleNode[] listSimpleNode = new SimpleNode[this.listNodes.size()];
        this.listNodes.toArray(listSimpleNode);
        SimpleRelationship[] listSimpleRelationship = new SimpleRelationship[this.listRelationships.size()];
        this.listRelationships.toArray(listSimpleRelationship);
        try {
            this.currentLayoutAlgorithm.applyLayout((LayoutEntity[])listSimpleNode, (LayoutRelationship[])listSimpleRelationship, layoutArea.preciseX(), layoutArea.preciseY(), layoutArea.preciseWidth() - 40.0, layoutArea.preciseHeight() - 5.0, false, false);
        }
        catch (InvalidLayoutConfiguration e) {
            Activator.getDefault().log(String.valueOf(e.getMessage()) + " : Layout cannot be applied", (Exception)((Object)e));
        }
        Map<EditPart, Rectangle> map = this.matchEditPartCoordinates();
        this.subEditor.execute(map);
    }

    private void createRelationships() {
        int i = 0;
        while (i < this.listNodes.size()) {
            List<EditPart> sources = this.getSourceRelationships((EditPart)this.listNodes.get(i).getRealObject());
            for (EditPart source : sources) {
                EditPart node = this.subEditor.getTarget(source);
                SimpleRelationship relationship = this.getSimpleRelationship(this.subEditor.getSource(source), this.subEditor.getTarget(source));
                if (!this.listRelationships.contains(relationship) && this.listNodesEditPart.contains(node)) {
                    this.listRelationships.add(relationship);
                }
                this.listNodes.get(i).addRelationship(relationship);
            }
            List<EditPart> targets = this.getTargetRelationships((EditPart)this.listNodes.get(i).getRealObject());
            for (EditPart target : targets) {
                EditPart node = this.subEditor.getSource(target);
                SimpleRelationship relationship = this.getSimpleRelationship(this.subEditor.getSource(target), this.subEditor.getTarget(target));
                if (!this.listRelationships.contains(relationship) && this.listNodesEditPart.contains(node)) {
                    this.listRelationships.add(relationship);
                }
                this.listNodes.get(i).addRelationship(relationship);
            }
            ++i;
        }
    }

    private void createNodes() {
        for (EditPart editPart : this.listEditPartSelected) {
            Rectangle coordinates;
            if (!this.subEditor.isNode(editPart) || (coordinates = this.subEditor.getBounds(editPart)) == null) continue;
            this.listNodes.add(this.getSimpleNode(editPart, coordinates));
            this.listNodesEditPart.add(editPart);
        }
    }

    public SimpleRelationship getSimpleRelationship(EditPart source, EditPart destination) {
        SimpleNode simpleNodeSource = null;
        SimpleNode simpleNodeDestination = null;
        for (SimpleNode sn : this.listNodes) {
            EditPart editPart = (EditPart)sn.getRealObject();
            if (editPart.equals(source)) {
                simpleNodeSource = sn;
            }
            if (!editPart.equals(destination)) continue;
            simpleNodeDestination = sn;
        }
        SimpleRelationship simpleRelationship = new SimpleRelationship(simpleNodeSource, simpleNodeDestination, true);
        return simpleRelationship;
    }

    public Map<EditPart, Rectangle> matchEditPartCoordinates() {
        HashMap<EditPart, Rectangle> map = new HashMap<EditPart, Rectangle>();
        for (SimpleNode node : this.listNodes) {
            Rectangle coordinates = new Rectangle((int)node.getXInLayout(), (int)node.getYInLayout(), (int)node.getWidthInLayout(), (int)node.getHeightInLayout());
            map.put((EditPart)node.getRealObject(), coordinates);
        }
        return map;
    }

    public SimpleNode getSimpleNode(EditPart element, Rectangle coordinates) {
        return this.getSimpleNode(element, coordinates, false);
    }

    public SimpleNode getSimpleNode(EditPart element, Rectangle coordinates, boolean ignoreInLayout) {
        SimpleNode node = new SimpleNode((Object)element, coordinates.preciseX(), coordinates.preciseY(), coordinates.preciseWidth(), coordinates.preciseHeight());
        node.ignoreInLayout(ignoreInLayout);
        return node;
    }

    public List<EditPart> getSourceRelationships(EditPart editPart) {
        GraphicalEditPart gep = (GraphicalEditPart)editPart;
        List sourceConnections = gep.getSourceConnections();
        return sourceConnections;
    }

    public List<EditPart> getTargetRelationships(EditPart editPart) {
        GraphicalEditPart gep = (GraphicalEditPart)editPart;
        List targetConnections = gep.getTargetConnections();
        return targetConnections;
    }
}

