/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.ui.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.contentassist.CompletionProposalUtils;
import org.eclipse.papyrus.infra.gmfdiag.xtext.glue.contentassist.CustomCompletionProposal;
import org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.stereotypeApplicationWithVSL.StereotypeApplicationRule;
import org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.stereotypeApplicationWithVSL.TagSpecificationRule;
import org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.ui.contentassist.AbstractStereotypeApplicationWithVSLProposalProvider;
import org.eclipse.papyrus.marte.vsl.ui.contentassist.VSLProposalUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class StereotypeApplicationWithVSLProposalProvider
extends AbstractStereotypeApplicationWithVSLProposalProvider {
    @Override
    public void completeTagSpecificationRule_Property(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        List<NamedElement> visibleProperties = this.getVisibleProperties(model);
        visibleProperties = this.sortByKindAndName(visibleProperties);
        for (EObject eObject : visibleProperties) {
            NamedElement namedElement = (NamedElement)eObject;
            if (!namedElement.getName().toLowerCase().contains(context.getPrefix().toLowerCase())) continue;
            String completionString = String.valueOf(context.getPrefix()) + namedElement.getName().substring(context.getPrefix().length()) + " = ";
            String displayString = namedElement.getName();
            if (namedElement instanceof TypedElement) {
                TypedElement typedElement = (TypedElement)namedElement;
                displayString = String.valueOf(displayString) + (typedElement.getType() != null ? " : " + typedElement.getType().getName() : "");
            }
            CustomCompletionProposal completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)namedElement, (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    private List<NamedElement> getVisibleProperties(EObject rule) {
        StereotypeApplicationRule stAppRule;
        ArrayList<NamedElement> visibleProperties = new ArrayList<NamedElement>();
        EObject context = rule;
        while (context != null && !(context instanceof StereotypeApplicationRule)) {
            context = context.eContainer();
        }
        if (context != null && (stAppRule = (StereotypeApplicationRule)context).getStereotype() != null) {
            visibleProperties.addAll((Collection<NamedElement>)stAppRule.getStereotype().getAllAttributes());
            ArrayList filteredList = new ArrayList(stAppRule.getStereotype().getAllAttributes());
            for (Property p : filteredList) {
                if (p.getName() != null && !p.getName().startsWith("base_") && !p.isDerived()) continue;
                visibleProperties.remove(p);
            }
            if (stAppRule.getTagSpecification() != null) {
                for (TagSpecificationRule tag : stAppRule.getTagSpecification()) {
                    if (tag.getProperty() == null || !visibleProperties.contains(tag.getProperty())) continue;
                    visibleProperties.remove(tag.getProperty());
                }
            }
        }
        return visibleProperties;
    }

    @Override
    public void completeExpressionValueRule_Expression(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model.eContainer() == null || !(model.eContainer() instanceof TagSpecificationRule)) {
            return;
        }
        TagSpecificationRule tagSpecificationRule = (TagSpecificationRule)model.eContainer();
        if (tagSpecificationRule.getProperty() == null || tagSpecificationRule.getProperty().getType() == null) {
            return;
        }
        Property p = tagSpecificationRule.getProperty();
        Map allProposals = VSLProposalUtils.buildProposalForType((Classifier)((Classifier)p.getType()), (MultiplicityElement)p);
        for (String s : allProposals.keySet()) {
            String completionString = s.substring(context.getPrefix().length());
            String displayString = s;
            CustomCompletionProposal completionProposal = null;
            if (allProposals.get(s) == null) {
                completionString = s.substring(context.getPrefix().length());
                displayString = s;
                completionProposal = CompletionProposalUtils.createCompletionProposal((String)completionString, (String)displayString, (ContentAssistContext)context);
                acceptor.accept((ICompletionProposal)completionProposal);
                continue;
            }
            if (!s.contains("|")) {
                displayString = s;
                completionString = s;
            } else {
                completionString = s.substring(0, s.indexOf("|"));
                displayString = s.substring(s.indexOf("|") + 1);
            }
            if (!displayString.contains(context.getPrefix())) continue;
            completionProposal = CompletionProposalUtils.createCompletionProposalWithReplacementOfPrefix((NamedElement)((NamedElement)allProposals.get(s)), (String)completionString, (String)displayString, (ContentAssistContext)context);
            acceptor.accept((ICompletionProposal)completionProposal);
        }
    }

    protected List<NamedElement> sortByKindAndName(List<NamedElement> list) {
        List<NamedElement> group;
        ArrayList<NamedElement> sortedList = new ArrayList<NamedElement>();
        HashMap<EClass, List<NamedElement>> namedElementGroups = new HashMap<EClass, List<NamedElement>>();
        for (NamedElement n : list) {
            if (!namedElementGroups.containsKey(n.eClass())) {
                group = new ArrayList<NamedElement>();
                group.add(n);
                namedElementGroups.put(n.eClass(), group);
                continue;
            }
            group = (List)namedElementGroups.get(n.eClass());
            boolean inserted = false;
            int i = 0;
            while (!inserted && i < group.size()) {
                if (((NamedElement)group.get(i)).getName().compareTo(n.getName()) > 0) {
                    group.add(i, n);
                    inserted = true;
                }
                ++i;
            }
            if (!inserted) {
                group.add(n);
            }
            namedElementGroups.put(n.eClass(), group);
        }
        for (EClass c : namedElementGroups.keySet()) {
            group = (List)namedElementGroups.get(c);
            sortedList.addAll(group);
        }
        return sortedList;
    }
}

