/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public abstract class AbstractRepositoryAction
extends BaseSelectionListenerAction {
    private IPapyrusRepository repository;
    private IWorkbenchPart part;

    public AbstractRepositoryAction(String text, ImageDescriptor enabledIcon, ImageDescriptor disabledIcon, IWorkbenchPart part) {
        super(text);
        this.part = part;
        this.setImageDescriptor(enabledIcon);
        this.setDisabledImageDescriptor(disabledIcon);
    }

    public AbstractRepositoryAction(String text, String sharedEnabledIcon, String sharedDisabledIcon, IWorkbenchPart part) {
        this(text, AbstractRepositoryAction.getSharedImage(part, sharedEnabledIcon), AbstractRepositoryAction.getSharedImage(part, sharedDisabledIcon), part);
    }

    public AbstractRepositoryAction(String text, IWorkbenchPart part) {
        this(text, (ImageDescriptor)null, (ImageDescriptor)null, part);
    }

    static ImageDescriptor getSharedImage(IWorkbenchPart part, String imageKey) {
        return ImageDescriptor.createFromImage((Image)part.getSite().getWorkbenchWindow().getWorkbench().getSharedImages().getImage(imageKey));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean result = super.updateSelection(selection);
        this.repository = (IPapyrusRepository)Iterators.getNext((Iterator)Iterators.filter((Iterator)selection.iterator(), IPapyrusRepository.class), null);
        result = result && this.repository != null && this.isEnabledFor(this.repository);
        return result;
    }

    protected IWorkbenchPart getPart() {
        return this.part;
    }

    protected abstract boolean isEnabledFor(IPapyrusRepository var1);

    protected abstract void run(IPapyrusRepository var1);

    public void run() {
        if (this.repository != null) {
            this.run(this.repository);
        }
    }
}

