/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.dialogs.AddRepositoryDialog;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.ui.IWorkbenchPart;

public class AddRepositoryAction
extends Action {
    private IWorkbenchPart part;

    public AddRepositoryAction(IWorkbenchPart part) {
        super(Messages.AddRepositoryAction_0, Activator.getIcon("add_repository"));
        this.part = part;
    }

    public void run() {
        AddRepositoryDialog dlg = new AddRepositoryDialog(this.part.getSite().getShell());
        if (dlg.open() == 0) {
            PapyrusRepositoryManager mgr = PapyrusRepositoryManager.INSTANCE;
            String url = dlg.getURL();
            IPapyrusRepository repository = mgr.getRepository(url);
            if (repository == null) {
                repository = mgr.createRepository(url);
                repository.setName(dlg.getName());
            }
            mgr.saveRepositories();
            if (!repository.isConnected()) {
                final IPapyrusRepository _repository = repository;
                try {
                    this.part.getSite().getWorkbenchWindow().run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            _repository.connect();
                        }
                    });
                }
                catch (Exception e) {
                    Activator.log.error("Unexpected exception in async repository connection.", (Throwable)e);
                }
            }
        }
    }
}

