/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncAction<T>
extends BaseSelectionListenerAction {
    protected final Class<? extends T> type;
    private T selection;

    public AsyncAction(Class<? extends T> type, String text, String icon) {
        this(type, text, Activator.getIcon(icon));
    }

    public AsyncAction(Class<? extends T> type, String text, ImageDescriptor icon) {
        super(text);
        this.type = type;
        this.setImageDescriptor(icon);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = this.coerce(selection.getFirstElement());
        return this.selection != null && super.updateSelection(selection);
    }

    protected T coerce(Object selection) {
        T result = null;
        if (this.type.isInstance(selection)) {
            result = this.type.cast(selection);
        } else if (selection instanceof IAdaptable) {
            result = this.type.cast(((IAdaptable)selection).getAdapter(this.type));
        }
        return result;
    }

    public void run() {
        if (this.selection != null && this.gatherInput(this.selection)) {
            new Job(this.getText()){
                {
                    this.setUser(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        AsyncAction.this.doRun(AsyncAction.this.selection, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    protected boolean gatherInput(T selection) {
        return true;
    }

    protected static IStatus error(String message, Throwable exception) {
        return new Status(4, "org.eclipse.papyrus.cdo.ui", message, exception);
    }

    protected static IStatus wrap(Collection<? extends IStatus> statuses, String summary) {
        Object result = statuses.size() == 1 ? (IStatus)Iterables.getOnlyElement(statuses) : new MultiStatus("org.eclipse.papyrus.cdo.ui", 0, (IStatus[])Iterables.toArray(statuses, IStatus.class), summary, null);
        return result;
    }

    protected abstract void doRun(T var1, IProgressMonitor var2) throws CoreException;
}

