/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.cdo.internal.ui.actions.AsyncAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsyncTransactionAction<T>
extends AsyncAction<T> {
    public AsyncTransactionAction(Class<? extends T> type, String text, String icon) {
        super(type, text, icon);
    }

    public AsyncTransactionAction(Class<? extends T> type, String text, ImageDescriptor icon) {
        super(type, text, icon);
    }

    protected CDOView getView(T selection) {
        if (!(selection instanceof CDOObject)) {
            throw new IllegalArgumentException("selection is not a CDOObject");
        }
        return ((CDOObject)selection).cdoView();
    }

    @Override
    protected void doRun(T selection, IProgressMonitor monitor) throws CoreException {
        CDOView view = this.getView(selection);
        if (view instanceof CDOTransaction) {
            this.doRun(selection, (CDOTransaction)view, monitor);
        } else {
            CDOID oid = selection instanceof CDOObject ? ((CDOObject)selection).cdoID() : null;
            CDOTransaction transaction = view.getSession().openTransaction();
            try {
                T localSelection = oid == null ? selection : this.type.cast(transaction.getObject(oid));
                this.doRun(localSelection, transaction, monitor);
                try {
                    transaction.commit();
                }
                catch (CommitException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.cdo.ui", "Failed to commit changes: " + this.getText(), (Throwable)e));
                }
            }
            finally {
                transaction.close();
            }
        }
    }

    protected abstract void doRun(T var1, CDOTransaction var2, IProgressMonitor var3) throws CoreException;
}

