/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import com.google.common.collect.Iterables;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.EresourceFactory;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.ui.actions.AsyncTransactionAction;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFolderAction
extends AsyncTransactionAction<CDOResourceNode> {
    private final IWorkbenchPart part;
    private String folderName;

    public CreateFolderAction(IWorkbenchPart part) {
        super(CDOResourceNode.class, Messages.CreateFolderAction_0, "create_folder");
        this.part = part;
    }

    @Override
    protected CDOResourceNode coerce(Object selection) {
        CDOView view;
        IInternalPapyrusRepository repository;
        CDOResourceNode result = (CDOResourceNode)super.coerce(selection);
        if (result == null && selection instanceof IInternalPapyrusRepository && (repository = (IInternalPapyrusRepository)selection).isConnected() && (view = repository.getMasterView()) != null) {
            result = view.getRootResource();
        }
        return result;
    }

    @Override
    protected boolean gatherInput(CDOResourceNode selection) {
        boolean result = false;
        InputDialog dialog = new InputDialog(this.part.getSite().getShell(), Messages.CreateFolderAction_1, Messages.CreateFolderAction_2, this.getDefaultFolderName(selection), this.createInputValidator(selection));
        if (dialog.open() == 0) {
            this.folderName = dialog.getValue().trim();
            result = true;
        }
        return result;
    }

    private Iterable<CDOResourceNode> getChildren(CDOResourceNode node) {
        Object result = node instanceof CDOResourceFolder ? ((CDOResourceFolder)node).getNodes() : (node instanceof CDOResource && ((CDOResource)node).isRoot() ? Iterables.filter((Iterable)((CDOResource)node).getContents(), CDOResourceNode.class) : Collections.emptyList());
        return result;
    }

    boolean nameExists(Iterable<CDOResourceNode> existingNodes, String name) {
        boolean result = false;
        for (CDOResourceNode next : existingNodes) {
            if (!name.equals(next.getName())) continue;
            result = true;
            break;
        }
        return result;
    }

    private String getDefaultFolderName(CDOResourceNode parent) {
        Iterable<CDOResourceNode> existing = this.getChildren(parent);
        String result = null;
        int i = 1;
        while (result == null) {
            result = "folder" + i;
            if (this.nameExists(existing, result)) {
                result = null;
            }
            ++i;
        }
        return result;
    }

    private IInputValidator createInputValidator(CDOResourceNode parent) {
        final Iterable<CDOResourceNode> existing = this.getChildren(parent);
        return new IInputValidator(){

            public String isValid(String newText) {
                String name;
                String string = name = newText == null ? "" : newText.trim();
                String result = name.length() == 0 ? Messages.CreateFolderAction_5 : (CreateFolderAction.this.nameExists(existing, name) ? Messages.CreateFolderAction_6 : null);
                return result;
            }
        };
    }

    @Override
    protected void doRun(CDOResourceNode selection, CDOTransaction transaction, IProgressMonitor monitor) {
        CDOResourceFolder folder = EresourceFactory.eINSTANCE.createCDOResourceFolder();
        folder.setName(this.folderName);
        if (selection instanceof CDOResourceFolder) {
            ((CDOResourceFolder)selection).getNodes().add((Object)folder);
        } else if (selection instanceof CDOResource) {
            ((CDOResource)selection).getContents().add((Object)folder);
        }
    }
}

