/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.ui.actions.AsyncTransactionAction;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusCDOEditorInput;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteModelAction
extends AsyncTransactionAction<DIModel> {
    private final IWorkbenchPart part;

    public DeleteModelAction(IWorkbenchPart part) {
        super(DIModel.class, Messages.DeleteModelAction_0, ImageDescriptor.createFromImage((Image)part.getSite().getWorkbenchWindow().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE")));
        this.part = part;
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    @Override
    protected CDOView getView(DIModel selection) {
        return selection.getResource().cdoView();
    }

    @Override
    protected boolean gatherInput(DIModel selection) {
        boolean result = false;
        if (MessageDialog.openQuestion((Shell)this.part.getSite().getShell(), (String)Messages.DeleteModelAction_1, (String)NLS.bind((String)Messages.DeleteModelAction_2, (Object)selection.getName()))) {
            URI uri;
            PapyrusCDOEditorInput input;
            IWorkbenchPage page = this.part.getSite().getPage();
            IEditorPart openEditor = page.findEditor((IEditorInput)(input = new PapyrusCDOEditorInput(uri = selection.getResource().getURI())));
            if (openEditor != null) {
                page.closeEditor(openEditor, false);
            }
            result = true;
        }
        return result;
    }

    @Override
    protected void doRun(DIModel selection, CDOTransaction transaction, IProgressMonitor monitor) throws CoreException {
        ArrayList failures = Lists.newArrayListWithExpectedSize((int)1);
        Object[] objectArray = selection.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID oid;
            CDOResource toDelete;
            Object next = objectArray[n2];
            if (next instanceof CDOResource && (toDelete = (CDOResource)transaction.getObject(oid = ((CDOResource)next).cdoID())) != null) {
                try {
                    toDelete.delete(null);
                }
                catch (Exception e) {
                    failures.add(DeleteModelAction.error("Failed to delete resource " + toDelete.getPath(), e));
                }
            }
            ++n2;
        }
        if (!failures.isEmpty()) {
            throw new CoreException(DeleteModelAction.wrap(failures, "Errors occurred in deleting model."));
        }
    }
}

