/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.cdo.core.CommitException;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.actions.AbstractRepositoryAction;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class DisconnectRepositoryAction
extends AbstractRepositoryAction {
    public DisconnectRepositoryAction(IWorkbenchPart part) {
        super(Messages.DisconnectRepositoryAction_0, Activator.getIcon("disconnect_repo_ena"), Activator.getIcon("disconnect_repo_dis"), part);
    }

    protected boolean isEnabledFor(IPapyrusRepository repository) {
        return repository.isConnected();
    }

    protected void run(final IPapyrusRepository repository) {
        final CommitException[] commitFailure = new CommitException[1];
        try {
            this.getPart().getSite().getWorkbenchWindow().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        repository.disconnect();
                    }
                    catch (CommitException e) {
                        commitFailure[0] = e;
                    }
                }
            });
        }
        catch (Exception e) {
            Activator.log.error("Unexpected exception in async repository connection.", (Throwable)e);
        }
        if (commitFailure[0] != null) {
            StatusAdapter adapter = new StatusAdapter(commitFailure[0].getStatus());
            adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.DisconnectRepositoryAction_2);
            StatusManager.getManager().handle(adapter, 2);
        }
    }
}

