/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusCDOEditorManager;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.statushandlers.StatusManager;

public class OpenPapyrusModelAction
extends BaseSelectionListenerAction {
    private final IWorkbenchPart part;

    public OpenPapyrusModelAction(IWorkbenchPart part) {
        super(Messages.OpenPapyrusModelAction_0);
        this.part = part;
    }

    public void run() {
        CDOResource res;
        IStructuredSelection sel = this.getStructuredSelection();
        if (sel != null && !sel.isEmpty() && (res = this.getResource(sel.getFirstElement())) != null) {
            try {
                URI uri = res.getURI();
                String name = uri.trimFileExtension().lastSegment();
                PapyrusCDOEditorManager.INSTANCE.openEditor(this.part.getSite().getPage(), uri, name);
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle(e.getStatus(), 2);
            }
        }
    }

    private CDOResource getResource(Object object) {
        CDOResource result = null;
        if (object instanceof CDOResource) {
            result = (CDOResource)object;
        } else if (object instanceof IAdaptable) {
            result = (CDOResource)((IAdaptable)object).getAdapter(CDOResource.class);
        }
        return result;
    }
}

