/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.CommitException;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.actions.AbstractRepositoryAction;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class RemoveRepositoryAction
extends AbstractRepositoryAction {
    public RemoveRepositoryAction(IWorkbenchPart part) {
        super(Messages.RemoveRepositoryAction_0, "IMG_TOOL_DELETE", "IMG_TOOL_DELETE_DISABLED", part);
        this.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    protected boolean isEnabledFor(IPapyrusRepository repository) {
        return true;
    }

    protected void run(IPapyrusRepository repository) {
        String message;
        boolean connected = repository.isConnected();
        String string = message = connected ? Messages.RemoveRepositoryAction_1 : Messages.RemoveRepositoryAction_2;
        if (MessageDialog.openQuestion((Shell)this.getPart().getSite().getShell(), (String)Messages.RemoveRepositoryAction_3, (String)NLS.bind((String)message, (Object)repository.getName()))) {
            PapyrusRepositoryManager mgr = PapyrusRepositoryManager.INSTANCE;
            if (!connected) {
                mgr.removeRepository(repository);
                mgr.saveRepositories();
            } else {
                try {
                    repository.disconnect();
                    mgr.removeRepository(repository);
                    mgr.saveRepositories();
                }
                catch (CommitException e) {
                    StatusAdapter adapter = new StatusAdapter(e.getStatus());
                    adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.RemoveRepositoryAction_4);
                    StatusManager.getManager().handle(adapter, 2);
                }
            }
        }
    }
}

