/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.actions;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.internal.ui.actions.AsyncTransactionAction;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameModelAction
extends AsyncTransactionAction<DIModel> {
    private final IWorkbenchPart part;
    private String newName;

    public RenameModelAction(IWorkbenchPart part) {
        super(DIModel.class, Messages.RenameModelAction_0, (ImageDescriptor)null);
        this.part = part;
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
    }

    @Override
    protected CDOView getView(DIModel selection) {
        return selection.getResource().cdoView();
    }

    @Override
    protected boolean gatherInput(DIModel selection) {
        boolean result = false;
        InputDialog dialog = new InputDialog(this.part.getSite().getShell(), Messages.RenameModelAction_1, Messages.RenameModelAction_2, RenameModelAction.getModelName(selection.getName()), this.createInputValidator(selection));
        if (dialog.open() == 0) {
            this.newName = RenameModelAction.getModelName(dialog.getValue().trim());
            result = true;
        }
        return result;
    }

    static String getModelName(String filename) {
        String suffix = "." + "di".toLowerCase();
        String result = filename;
        if (filename.toLowerCase().endsWith(suffix)) {
            result = filename.substring(0, filename.length() - suffix.length());
        }
        return result;
    }

    static String getBaseName(String filename) {
        return new Path(filename).removeFileExtension().toString();
    }

    String getNewName(String filename) {
        Path path = new Path(filename);
        Path result = new Path(this.newName);
        if (path.getFileExtension() != null) {
            result = result.addFileExtension(path.getFileExtension());
        }
        return result.toString();
    }

    @Override
    protected void doRun(DIModel selection, CDOTransaction transaction, IProgressMonitor monitor) throws CoreException {
        ArrayList failures = Lists.newArrayListWithExpectedSize((int)1);
        Object[] objectArray = selection.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID oid;
            CDOResource toRename;
            Object next = objectArray[n2];
            if (next instanceof CDOResource && (toRename = (CDOResource)transaction.getObject(oid = ((CDOResource)next).cdoID())) != null) {
                try {
                    toRename.setName(this.getNewName(toRename.getName()));
                }
                catch (Exception e) {
                    failures.add(RenameModelAction.error("Failed to rename resource " + toRename.getPath(), e));
                }
            }
            ++n2;
        }
        if (!failures.isEmpty()) {
            throw new CoreException(RenameModelAction.wrap(failures, "Errors occurred in renaming model."));
        }
    }

    private IInputValidator createInputValidator(DIModel model) {
        final CDOResource primaryResource = model.getResource();
        CDOResourceFolder parent = primaryResource.getFolder();
        if (parent == null) {
            parent = (CDOResourceNode)primaryResource.eResource();
        }
        CDOResourceFolder container = parent;
        return new IInputValidator((CDOResourceNode)container){
            private final /* synthetic */ CDOResourceNode val$container;
            {
                this.val$container = cDOResourceNode;
            }

            public String isValid(String newText) {
                String result = null;
                if ((newText = Strings.nullToEmpty((String)newText).trim()).equals("")) {
                    result = Messages.RenameModelAction_7;
                } else if (newText.indexOf(47) >= 0 || newText.indexOf(92) >= 0) {
                    result = Messages.RenameModelAction_8;
                } else if (RenameModelAction.getModelName(newText).equals(RenameModelAction.getModelName(primaryResource.getName()))) {
                    result = "";
                } else {
                    String base = RenameModelAction.getBaseName(newText);
                    for (CDOResourceNode next : Iterables.filter((Iterable)this.val$container.eContents(), CDOResourceNode.class)) {
                        if (!base.equals(RenameModelAction.getBaseName(next.getName()))) continue;
                        result = NLS.bind((String)Messages.RenameModelAction_10, (Object)next.getName());
                    }
                }
                return result;
            }
        };
    }
}

