/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.decorators;

import org.eclipse.emf.cdo.dawn.gmf.appearance.DawnEditPartStylizer;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.cdo.internal.ui.SharedImages;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;
import org.eclipse.swt.graphics.Image;

abstract class PapyrusEditPartStylizer
extends DawnEditPartStylizer {
    public Image getImage(Object element, DawnState state) {
        Image result;
        switch (state) {
            case LOCKED_LOCALLY: {
                result = SharedImages.getImage("self_locked_ovr24");
                break;
            }
            case LOCKED_REMOTELY: {
                result = SharedImages.getImage("other_locked_ovr24");
                break;
            }
            case CONFLICT: {
                result = SharedImages.getImage("conflicted_ovr24");
                break;
            }
            default: {
                result = super.getImage(element, state);
            }
        }
        return result;
    }

    public void setDefault(EditPart editPart) {
        this.setState(editPart, DawnState.CLEAN);
    }

    public void setLocked(EditPart editPart, int type) {
        DawnState state;
        switch (type) {
            case 4: {
                state = DawnState.LOCKED_REMOTELY;
                break;
            }
            case 3: {
                state = DawnState.LOCKED_LOCALLY;
                break;
            }
            default: {
                state = DawnState.LOCKED_REMOTELY;
            }
        }
        this.setState(editPart, state);
    }

    public void setConflicted(EditPart editPart, int type) {
        this.setState(editPart, DawnState.CONFLICT);
    }

    protected void setState(final EditPart editPart, DawnState state) {
        View view = (View)editPart.getModel();
        CDOStateAdapter.setState((Notifier)view, state);
        DisplayUtils.getDisplay().asyncExec(new Runnable(){

            public void run() {
                editPart.refresh();
            }
        });
    }
}

