/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RepositoryCredentialsDialog
extends TitleAreaDialog {
    private static final String TITLE = Messages.RepositoryCredentialsDialog_0;
    private static final String MESSAGE = Messages.RepositoryCredentialsDialog_1;
    private final IPapyrusRepository repository;
    private final String message;
    private Text usernameText;
    private Text passwordText;
    private Button rememberCheckbox;
    private IPasswordCredentials credentials;

    public RepositoryCredentialsDialog(Shell parentShell, IPapyrusRepository repository) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x20);
        this.repository = repository;
        this.message = NLS.bind((String)MESSAGE, (Object)repository.getName());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(TITLE);
        this.setMessage(this.message);
        Composite result = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(result, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        new Label(main, 0).setText(Messages.RepositoryCredentialsDialog_2);
        this.usernameText = new Text(main, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)this.usernameText);
        new Label(main, 0).setText(Messages.RepositoryCredentialsDialog_3);
        this.passwordText = new Text(main, 0x400800);
        GridDataFactory.fillDefaults().applyTo((Control)this.passwordText);
        this.rememberCheckbox = new Button(main, 32);
        this.rememberCheckbox.setText(Messages.RepositoryCredentialsDialog_4);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.rememberCheckbox);
        if (this.repository.getUsername() != null) {
            this.usernameText.setText(this.repository.getUsername());
        }
        if (this.repository.getPassword() != null) {
            this.passwordText.setText(this.repository.getPassword());
        }
        return result;
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.getShell().pack();
        return result;
    }

    protected void okPressed() {
        String username = this.usernameText.getText().trim();
        String password = this.passwordText.getText().trim();
        this.credentials = new PasswordCredentials(username, password.toCharArray());
        if (this.rememberCheckbox.getSelection()) {
            this.repository.setUsername(username);
            this.repository.setPassword(password);
            PapyrusRepositoryManager.INSTANCE.saveRepositories();
        }
        super.okPressed();
    }

    public IPasswordCredentials getCredentials() {
        return this.credentials;
    }
}

