/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dialogs;

import com.google.common.base.Supplier;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.wizards.RepositorySelectionBlock;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySelectionDialog
extends TitleAreaDialog {
    private static final String TITLE = Messages.RepositorySelectionDialog_0;
    private final IPapyrusRepositoryManager repoMan;
    private final Supplier<? extends IRunnableContext> runnableContext;
    private final EventBus bus;
    private final IPapyrusRepository initialSelection;
    private IPapyrusRepository selectedRepository;
    private RepositorySelectionBlock repoSelectionBlock;

    public RepositorySelectionDialog(Shell parentShell, IPapyrusRepositoryManager repoMan, IPapyrusRepository initialSelection, Supplier<? extends IRunnableContext> runnableContext) {
        super(parentShell);
        this.repoMan = repoMan;
        this.runnableContext = runnableContext;
        this.bus = new EventBus("repositorySelectionDialog");
        this.initialSelection = initialSelection;
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x20);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(TITLE);
        this.setMessage(Messages.RepositorySelectionDialog_1);
        Composite result = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(result, 0);
        main.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        this.repoSelectionBlock = new RepositorySelectionBlock(this.repoMan, this.bus, this.runnableContext);
        this.repoSelectionBlock.createControl(main);
        this.bus.register((Object)this);
        this.repoSelectionBlock.setSelectedRepository(this.initialSelection);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.setSelectedRepository(this.initialSelection);
    }

    public IPapyrusRepository getSelectedRepository() {
        return this.selectedRepository;
    }

    @Subscribe
    public void setSelectedRepository(IPapyrusRepository repository) {
        Button ok = this.getButton(0);
        if (ok != null) {
            ok.setEnabled(repository != null);
        }
    }

    protected void okPressed() {
        this.selectedRepository = this.repoSelectionBlock.getSelectedRepository();
        super.okPressed();
    }
}

