/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dnd;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOResourceURITransferData {
    private final List<URI> uris;

    public CDOResourceURITransferData(Iterable<? extends CDOResourceNode> resourceNodes) {
        this((List<URI>)ImmutableList.copyOf((Iterable)Iterables.transform(resourceNodes, (Function)new Function<CDOResourceNode, URI>(){

            public URI apply(CDOResourceNode input) {
                return input.getURI();
            }
        })));
    }

    private CDOResourceURITransferData(List<URI> uris) {
        this.uris = uris;
    }

    public List<URI> getURIs() {
        return this.uris;
    }

    public byte[] serialize() {
        ByteArrayDataOutput data = ByteStreams.newDataOutput();
        data.writeInt(this.uris.size());
        for (URI next : this.uris) {
            data.writeUTF(next.toString());
        }
        return data.toByteArray();
    }

    public static CDOResourceURITransferData deserialize(byte[] serial) {
        ImmutableList.Builder uris = ImmutableList.builder();
        ByteArrayDataInput data = ByteStreams.newDataInput((byte[])serial);
        int count = data.readInt();
        int i = 0;
        while (i < count) {
            uris.add((Object)URI.createURI((String)data.readUTF()));
            ++i;
        }
        return new CDOResourceURITransferData((List<URI>)uris.build());
    }
}

