/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dnd;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.papyrus.cdo.core.util.CDOFunctions;
import org.eclipse.papyrus.cdo.core.util.CDOPredicates;
import org.eclipse.papyrus.cdo.internal.ui.dnd.CDOResourceURITransferData;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDragAdapter
extends DragSourceAdapter {
    private static final Transfer[] TRANSFERS = new Transfer[]{PluginTransfer.getInstance()};
    private final StructuredViewer viewer;

    protected ResourceDragAdapter(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public static ResourceDragAdapter install(StructuredViewer viewer) {
        ResourceDragAdapter result = new ResourceDragAdapter(viewer);
        viewer.addDragSupport(18, TRANSFERS, (DragSourceListener)result);
        return result;
    }

    protected IStructuredSelection getViewerSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = this.getViewerSelection();
        event.doit = this.acceptSelection(selection.toList());
    }

    protected boolean acceptSelection(List<?> selection) {
        return !selection.isEmpty() && Iterables.all(selection, (Predicate)CDOPredicates.adaptsTo(CDOResourceNode.class));
    }

    public void dragSetData(DragSourceEvent event) {
        Transfer[] transferArray = TRANSFERS;
        int n = TRANSFERS.length;
        int n2 = 0;
        while (n2 < n) {
            Transfer transfer = transferArray[n2];
            if (transfer.isSupportedType(event.dataType)) {
                if (transfer instanceof LocalSelectionTransfer) {
                    event.data = this.getViewerSelection();
                } else if (transfer instanceof PluginTransfer) {
                    CDOResourceURITransferData data = this.getResourceURIs(this.getViewerSelection());
                    event.data = new PluginTransferData("org.eclipse.papyrus.cdo.ui.modelDropAction", data.serialize());
                }
            }
            ++n2;
        }
    }

    protected CDOResourceURITransferData getResourceURIs(IStructuredSelection selection) {
        return new CDOResourceURITransferData(Iterables.filter((Iterable)Iterables.transform((Iterable)selection.toList(), (Function)CDOFunctions.adapt(CDOResource.class)), (Predicate)Predicates.notNull()));
    }
}

