/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.dnd;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.util.CDOFunctions;
import org.eclipse.papyrus.cdo.core.util.CDOPredicates;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.dnd.CDOResourceURITransferData;
import org.eclipse.papyrus.cdo.internal.ui.handlers.ImportModelsHandler;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;
import org.eclipse.ui.part.ResourceTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDropAdapter
extends ViewerDropAdapter {
    private static final Transfer[] TRANSFERS = new Transfer[]{ResourceTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), PluginTransfer.getInstance()};
    private final Predicate<Object> validDropTarget = Predicates.or((Predicate)CDOPredicates.adaptsTo(CDOResourceFolder.class), (Predicate)CDOPredicates.adaptsTo(IPapyrusRepository.class));
    private final Function<Object, CDOResourceNode> asNode = CDOFunctions.adapt(CDOResourceNode.class);

    protected ResourceDropAdapter(StructuredViewer viewer) {
        super((Viewer)viewer);
    }

    public static ResourceDropAdapter install(StructuredViewer viewer) {
        ResourceDropAdapter result = new ResourceDropAdapter(viewer);
        viewer.addDropSupport(18, TRANSFERS, (DropTargetListener)result);
        return result;
    }

    public boolean performDrop(Object data) {
        boolean result = false;
        if (data instanceof IResource[]) {
            data = new StructuredSelection((Object[])((IResource[])data));
        } else if (data instanceof PluginTransferData && "org.eclipse.ui.navigator.PluginDropAction".equals(((PluginTransferData)data).getExtensionId())) {
            String viewerID = new String(((PluginTransferData)data).getData());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart view = page.findView(viewerID);
            if (view != null) {
                data = view.getSite().getSelectionProvider().getSelection();
            }
        }
        CDOResourceNode dropTarget = this.adaptDropTarget(this.getCurrentTarget());
        if (dropTarget != null) {
            Iterable<IFile> diFiles;
            PluginTransferData ptData;
            Iterable<Object> toMove = Collections.emptyList();
            if (data instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)data;
                toMove = this.getResourceNodeAdaptables(selection);
            } else if (data instanceof PluginTransferData && "org.eclipse.papyrus.cdo.ui.modelDropAction".equals((ptData = (PluginTransferData)data).getExtensionId())) {
                CDOResourceURITransferData uris = CDOResourceURITransferData.deserialize(ptData.getData());
                toMove = this.getResourceNodeAdaptables(uris.getURIs());
            }
            if (!Iterables.isEmpty(toMove)) {
                result = this.moveResourceNodes(dropTarget, toMove);
            } else if (data instanceof IStructuredSelection && !Iterables.isEmpty(diFiles = this.getDIFiles((IStructuredSelection)data))) {
                result = this.importModels(dropTarget, diFiles);
            }
        }
        return result;
    }

    protected boolean moveResourceNodes(final CDOResourceNode dropTarget, final Iterable<?> resourceNodes) {
        boolean result = false;
        Iterable nodes = Iterables.transform(resourceNodes, (Function)CDOFunctions.adapt(CDOResourceNode.class));
        for (CDOResourceNode next : nodes) {
            result = true;
            if (!this.contains(dropTarget, next)) continue;
            result = false;
            break;
        }
        if (result) {
            new Job(Messages.ResourceDropAdapter_1){
                {
                    super($anonymous0);
                    this.setUser(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    return ResourceDropAdapter.this.doMove(dropTarget, resourceNodes);
                }
            }.schedule();
        }
        return result;
    }

    protected boolean importModels(CDOResourceNode dropTarget, Iterable<IFile> diFiles) {
        URI uri;
        IPapyrusRepository repository;
        boolean result = false;
        IWorkbenchWindow window = null;
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow next = iWorkbenchWindowArray[n2];
            if (next.getShell() == this.getViewer().getControl().getShell()) {
                window = next;
                break;
            }
            ++n2;
        }
        if (window != null && (repository = PapyrusRepositoryManager.INSTANCE.getRepositoryForURI(uri = dropTarget.getURI())) != null) {
            ArrayList papyrusFiles = Lists.newArrayList();
            for (IFile next : diFiles) {
                IPapyrusFile papyrusFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(next);
                if (papyrusFile == null) continue;
                papyrusFiles.add(papyrusFile);
            }
            if (!papyrusFiles.isEmpty()) {
                result = true;
                ImportModelsHandler.importModels(window, (IStructuredSelection)new StructuredSelection((List)papyrusFiles), repository);
            }
        }
        return result;
    }

    protected IStatus doMove(CDOResourceNode destination, Iterable<?> nodeAdaptables) {
        IStatus result = Status.OK_STATUS;
        CDOTransaction transaction = destination.cdoView().getSession().openTransaction();
        try {
            try {
                CDOResourceNode newParent = this.getCorrespondent(destination, (CDOView)transaction);
                for (Object next : nodeAdaptables) {
                    if (next instanceof DIModel) {
                        for (CDOResourceNode cDOResourceNode : this.getResourceNodes(Arrays.asList(((DIModel)((Object)next)).getChildren()))) {
                            this.moveTo(newParent, this.getCorrespondent(cDOResourceNode, (CDOView)transaction));
                        }
                        continue;
                    }
                    this.moveTo(newParent, this.getCorrespondent((CDOResourceNode)this.asNode.apply(next), (CDOView)transaction));
                }
                transaction.commit();
            }
            catch (CoreException e) {
                result = e.getStatus();
                transaction.close();
            }
            catch (Exception e) {
                result = ResourceDropAdapter.error(Messages.ResourceDropAdapter_3, e);
                transaction.close();
            }
        }
        finally {
            transaction.close();
        }
        return result;
    }

    protected CDOResourceNode getCorrespondent(CDOResourceNode node, CDOView view) throws CoreException {
        CDOResourceFolder result;
        block6: {
            try {
                if (node == null) {
                    throw new CoreException(ResourceDropAdapter.error(Messages.ResourceDropAdapter_2));
                }
                if (node instanceof CDOResourceFolder) {
                    result = view.getResourceFolder(node.getPath());
                    break block6;
                }
                if (node instanceof CDOResource) {
                    result = view.getResource(node.getPath());
                    break block6;
                }
                throw new CoreException(ResourceDropAdapter.error(String.valueOf(Messages.ResourceDropAdapter_4) + node.getClass().getName()));
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException(ResourceDropAdapter.error(e.getLocalizedMessage(), e));
            }
        }
        return result;
    }

    protected static IStatus error(String message) {
        return ResourceDropAdapter.error(message, null);
    }

    protected static IStatus error(String message, Throwable exception) {
        return new Status(4, "org.eclipse.papyrus.cdo.ui", message, exception);
    }

    protected void moveTo(CDOResourceNode newParent, CDOResourceNode node) throws CoreException {
        String newPath;
        String string = newPath = node == null ? null : new Path(newParent.getPath()).append(node.getName()).toString();
        if (node == null) {
            throw new CoreException(ResourceDropAdapter.error(Messages.ResourceDropAdapter_0));
        }
        if (newParent.cdoView().hasResource(newPath)) {
            throw new CoreException(ResourceDropAdapter.error(NLS.bind((String)Messages.ResourceDropAdapter_6, (Object)newPath)));
        }
        node.setPath(newPath);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        boolean result = false;
        LocalSelectionTransfer local = LocalSelectionTransfer.getTransfer();
        if (local.isSupportedType(transferType) && local.getSelection() instanceof IStructuredSelection && this.isValidResourceContainer(target)) {
            IStructuredSelection selection = (IStructuredSelection)local.getSelection();
            CDOResourceNode dropTarget = this.adaptDropTarget(target);
            if (dropTarget != null && !Iterables.isEmpty(this.getDIFiles(selection))) {
                result = true;
            }
        } else if (PluginTransfer.getInstance().isSupportedType(transferType) && this.isValidResourceContainer(target)) {
            result = true;
        } else if (ResourceTransfer.getInstance().isSupportedType(transferType) && this.isValidResourceContainer(target)) {
            result = true;
        }
        return result;
    }

    protected boolean isValidResourceContainer(Object dropTarget) {
        return this.validDropTarget.apply(dropTarget);
    }

    protected CDOResourceNode adaptDropTarget(Object dropTarget) {
        CDOView view;
        CDOResourceNode result = (CDOResourceNode)CDOFunctions.adapt(CDOResourceNode.class).apply(dropTarget);
        if (result == null && (view = ((IInternalPapyrusRepository)dropTarget).getMasterView()) != null) {
            result = view.getRootResource();
        }
        return result;
    }

    protected boolean contains(CDOResourceNode parent, CDOResourceNode child) {
        CDOResource resource;
        boolean result = false;
        if (parent instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)parent;
            result = folder.getNodes().contains((Object)child);
        } else if (parent instanceof CDOResource && (resource = (CDOResource)parent).isRoot()) {
            result = resource.getContents().contains((Object)child);
        }
        return result;
    }

    protected Iterable<?> getResourceNodeAdaptables(IStructuredSelection selection) {
        return Iterables.filter((Iterable)selection.toList(), (Predicate)CDOPredicates.adaptsTo(CDOResourceNode.class));
    }

    protected Iterable<?> getResourceNodeAdaptables(Iterable<URI> uris) {
        ArrayList result = Lists.newArrayList();
        for (URI next : uris) {
            CDOView view;
            IPapyrusRepository repo = PapyrusRepositoryManager.INSTANCE.getRepositoryForURI(next);
            if (repo == null || (view = ((IInternalPapyrusRepository)repo).getMasterView()) == null) continue;
            String path = CDOURIUtil.extractResourcePath((URI)next);
            try {
                CDOResourceNode node = view.getResourceNode(path);
                if (node instanceof CDOResource) {
                    DIModel diModel = DIModel.getInstance((CDOResource)node, false);
                    if (diModel == null) continue;
                    result.add(diModel);
                    continue;
                }
                if (!(node instanceof CDOResourceNode)) continue;
                result.add(node);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected Iterable<? extends CDOResourceNode> getResourceNodes(IStructuredSelection selection) {
        return this.getResourceNodes(selection.toList());
    }

    protected Iterable<? extends CDOResourceNode> getResourceNodes(Iterable<?> objects) {
        return Iterables.filter((Iterable)Iterables.transform(objects, this.asNode), (Predicate)Predicates.notNull());
    }

    protected Iterable<IFile> getDIFiles(IStructuredSelection selection) {
        Iterable papyrusFiles = Iterables.filter((Iterable)selection.toList(), IPapyrusFile.class);
        Iterable files = Iterables.filter((Iterable)Iterables.filter((Iterable)selection.toList(), IFile.class), (Predicate)new Predicate<IFile>(){

            public boolean apply(IFile input) {
                return PapyrusModelHelper.getPapyrusModelFactory().isDi((IResource)input);
            }
        });
        return Iterables.concat((Iterable)files, (Iterable)Iterables.transform((Iterable)papyrusFiles, (Function)new Function<IPapyrusFile, IFile>(){

            public IFile apply(IPapyrusFile input) {
                return input.getMainFile();
            }
        }));
    }
}

