/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.editors;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditorSupport;
import org.eclipse.emf.cdo.dawn.gmf.synchronize.DawnConflictHelper;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareModelSet;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;
import org.eclipse.papyrus.cdo.internal.ui.editors.DawnEditorAdapter;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusGMFEditorSupport;
import org.eclipse.papyrus.cdo.internal.ui.util.UIUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.DefaultGraphicalEditorSupport;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IConflictingEditPartFilter;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusDiagramEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DawnGraphicalEditorSupport
extends DefaultGraphicalEditorSupport {
    private final ServicesRegistry registry;

    public DawnGraphicalEditorSupport(ServicesRegistry registry) {
        this.registry = registry;
    }

    public void initialize(GraphicalEditor editor) {
        CDOView view;
        if (editor instanceof DiagramDocumentEditor && (view = this.getCDOView()) != null) {
            DiagramDocumentEditor diagramEditor = (DiagramDocumentEditor)editor;
            this.initialize(diagramEditor, view);
        }
        super.initialize(editor);
    }

    protected void initialize(final DiagramDocumentEditor diagramEditor, CDOView view) {
        DawnEditorAdapter adapter = new DawnEditorAdapter(diagramEditor);
        final PapyrusGMFEditorSupport dawnSupport = new PapyrusGMFEditorSupport(adapter);
        adapter.setEditorSupport((IDawnEditorSupport)dawnSupport);
        adapter.setView(this.getCDOView());
        dawnSupport.setView(adapter.getView());
        UIUtil.later(new Runnable(){

            public void run() {
                DiagramEditPart diagramEP = diagramEditor.getDiagramEditPart();
                if (diagramEP instanceof PapyrusDiagramEditPart) {
                    ((PapyrusDiagramEditPart)diagramEP).setConflictingEditPartFilter(DawnGraphicalEditorSupport.this.createConflictingEditPartFilter());
                }
            }
        });
        dawnSupport.registerListeners();
        final Map<Object, DawnState> remoteLocks = this.getRemoteLocks(diagramEditor);
        if (!remoteLocks.isEmpty()) {
            UIUtil.later(new Runnable(){

                public void run() {
                    dawnSupport.handleRemoteLockChanges(remoteLocks);
                    for (Object next : remoteLocks.keySet()) {
                        EObject element = CDOUtil.getEObject((EObject)((CDOObject)next));
                        View view = DawnDiagramUpdater.findViewByContainer((EObject)element);
                        CDOStateAdapter.setState((Notifier)view, (DawnState)remoteLocks.get(next));
                    }
                }
            });
        }
    }

    CDOView getCDOView() {
        CDOView result = null;
        try {
            ModelSet modelSet = (ModelSet)this.registry.getService(ModelSet.class);
            if (modelSet instanceof CDOAwareModelSet) {
                result = ((CDOAwareModelSet)modelSet).getCDOView();
            }
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return result;
    }

    private Map<Object, DawnState> getRemoteLocks(DiagramDocumentEditor diagramEditor) {
        HashMap result = Maps.newHashMap();
        Diagram diagram = diagramEditor.getDiagram();
        if (diagram != null) {
            TreeIterator iter = EcoreUtil.getAllProperContents(Collections.singleton(diagram), (boolean)false);
            while (iter.hasNext()) {
                CDOObject next = CDOUtils.getCDOObject((EObject)((EObject)iter.next()));
                if (next == null || !CDOUtils.isLocked((CDOObject)next, (boolean)true)) continue;
                result.put(next, DawnState.LOCKED_REMOTELY);
            }
        }
        return result;
    }

    private IConflictingEditPartFilter createConflictingEditPartFilter() {
        return new IConflictingEditPartFilter(){

            public boolean isConflicting(EditPart editPart) {
                Object model = editPart.getModel();
                return model instanceof EObject && DawnConflictHelper.isConflicted((EObject)((EObject)model));
            }
        };
    }
}

