/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.editors;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IResourceSetDisposalApprover;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.editors.DawnEditorAdapter;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusCDOEditorInput;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusTransactionListener;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.util.UIUtil;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class PapyrusCDOEditorManager {
    public static final PapyrusCDOEditorManager INSTANCE = new PapyrusCDOEditorManager();
    private final BiMap<IEditorPart, CDOView> editors = HashBiMap.create();
    private final Cache<IWorkbenchPage, EditorListener> editorListeners = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<IWorkbenchPage, EditorListener>(){

        public EditorListener load(IWorkbenchPage key) {
            EditorListener result = new EditorListener();
            key.addPartListener((IPartListener)result);
            return result;
        }
    });
    private IResourceSetDisposalApprover disposalApprover;

    private PapyrusCDOEditorManager() {
    }

    public IEditorPart openEditor(IWorkbenchPage page, URI uri, String name) throws PartInitException {
        IInternalPapyrusRepository repository = this.getRepository(uri);
        repository.addResourceSetDisposalApprover(this.getDisposalApprover());
        IEditorPart result = page.openEditor((IEditorInput)new PapyrusCDOEditorInput(uri, name), "org.eclipse.papyrus.infra.core.papyrusEditor");
        EditingDomain domain = (EditingDomain)result.getAdapter(EditingDomain.class);
        ResourceSet resourceSet = domain.getResourceSet();
        CDOView view = repository.getCDOView(resourceSet);
        this.add(view, result);
        if (view instanceof CDOTransaction) {
            ServicesRegistry services = (ServicesRegistry)result.getAdapter(ServicesRegistry.class);
            view.addListener((IListener)new PapyrusTransactionListener(services, resourceSet));
        }
        return result;
    }

    private IResourceSetDisposalApprover getDisposalApprover() {
        if (this.disposalApprover == null) {
            this.disposalApprover = new ResourceSetDisposalApprover();
        }
        return this.disposalApprover;
    }

    IInternalPapyrusRepository getRepository(URI uri) {
        return (IInternalPapyrusRepository)PapyrusRepositoryManager.INSTANCE.getRepositoryForURI(uri);
    }

    void add(CDOView view, final IEditorPart editor) {
        this.editors.put((Object)editor, (Object)view);
        view.addListener((IListener)new CDOViewListener(editor));
        try {
            ((EditorListener)this.editorListeners.get((Object)editor.getSite().getPage(), (Callable)new Callable<EditorListener>(){

                @Override
                public EditorListener call() throws Exception {
                    EditorListener listener = new EditorListener();
                    editor.getSite().getPage().addPartListener((IPartListener)listener);
                    return listener;
                }
            })).addEditor(editor);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
    }

    void closed(IEditorPart editor) {
        this.editors.remove((Object)editor);
        DawnEditorAdapter.removeAdapter(editor);
    }

    private class CDOViewListener
    extends LifecycleEventAdapter {
        private final IEditorPart editor;

        CDOViewListener(IEditorPart editor) {
            this.editor = editor;
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            UIUtil.later(new Runnable(){

                public void run() {
                    if (PapyrusCDOEditorManager.this.editors.containsKey((Object)CDOViewListener.this.editor)) {
                        CDOViewListener.this.editor.getSite().getPage().closeEditor(CDOViewListener.this.editor, false);
                    }
                }
            });
            lifecycle.removeListener((IListener)this);
        }
    }

    private class EditorListener
    implements IPartListener {
        private final Set<IEditorPart> editors = Sets.newHashSet();

        private EditorListener() {
        }

        void addEditor(IEditorPart editor) {
            this.editors.add(editor);
        }

        public void partClosed(IWorkbenchPart part) {
            if (this.editors.remove(part)) {
                IEditorPart editor = (IEditorPart)part;
                PapyrusCDOEditorManager.this.closed(editor);
            }
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceSetDisposalApprover
    implements IResourceSetDisposalApprover {
        private ResourceSetDisposalApprover() {
        }

        public IResourceSetDisposalApprover.DisposeAction disposalRequested(IPapyrusRepository repository, Collection<ResourceSet> resourceSets) {
            IResourceSetDisposalApprover.DisposeAction result = IResourceSetDisposalApprover.DisposeAction.CLOSE;
            IInternalPapyrusRepository internal = (IInternalPapyrusRepository)repository;
            final ArrayList dirty = Lists.newArrayList();
            for (ResourceSet next : resourceSets) {
                CDOView view = internal.getCDOView(next);
                IEditorPart editor = (IEditorPart)PapyrusCDOEditorManager.this.editors.inverse().get((Object)view);
                if (editor == null || !editor.isDirty()) continue;
                dirty.add(editor);
            }
            if (!dirty.isEmpty()) {
                Future<Integer> dlgResult = UIUtil.call(new Callable<Integer>(){

                    @Override
                    public Integer call() {
                        MessageDialog dlg = new MessageDialog(((IEditorPart)dirty.get(0)).getSite().getShell(), Messages.PapyrusCDOEditorManager_1, null, Messages.PapyrusCDOEditorManager_2, 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                        return dlg.open();
                    }
                });
                try {
                    switch (dlgResult.get()) {
                        case 0: {
                            result = IResourceSetDisposalApprover.DisposeAction.SAVE;
                            break;
                        }
                        case 1: {
                            result = IResourceSetDisposalApprover.DisposeAction.CLOSE;
                            break;
                        }
                        case 2: {
                            result = IResourceSetDisposalApprover.DisposeAction.NONE;
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
            return result;
        }
    }
}

