/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.editors;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.appearance.DawnElementStylizer;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.gmf.editors.impl.DawnGMFEditorSupport;
import org.eclipse.emf.cdo.dawn.gmf.notifications.impl.DawnGMFHandler;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.dawn.ui.stylizer.DawnElementStylizerRegistry;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusGMFHandler;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusGMFLockingHandler;
import org.eclipse.papyrus.cdo.internal.ui.util.UIUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusGMFEditorSupport
extends DawnGMFEditorSupport {
    private static final Predicate<EStructuralFeature.Setting> IS_VIEW_REFERENCE = new Predicate<EStructuralFeature.Setting>(){

        public boolean apply(EStructuralFeature.Setting input) {
            return input.getEStructuralFeature() == NotationPackage.Literals.VIEW__ELEMENT;
        }
    };
    private static final Function<EStructuralFeature.Setting, View> OWNER_VIEW = new Function<EStructuralFeature.Setting, View>(){

        public View apply(EStructuralFeature.Setting input) {
            return (View)input.getEObject();
        }
    };

    public PapyrusGMFEditorSupport(IDawnEditor editor) {
        super(editor);
    }

    protected DawnGMFHandler createDawnGMFHandler(IDawnEditor editor) {
        return new PapyrusGMFHandler(editor);
    }

    protected BasicDawnListener getLockingHandler() {
        return new PapyrusGMFLockingHandler(this.getEditor());
    }

    public void lockObject(Object objectToBeLocked) {
        if (objectToBeLocked instanceof EditPart) {
            super.lockObject(objectToBeLocked);
            CDOObject cdo = CDOUtils.getCDOObject((EObject)PapyrusGMFEditorSupport.getSemanticElement((EditPart)objectToBeLocked));
            if (cdo != null) {
                this.updateAppearance(cdo);
            }
        } else {
            CDOObject cdo;
            EObject element = EMFHelper.getEObject((Object)objectToBeLocked);
            CDOObject cDOObject = cdo = element == null ? null : CDOUtils.getCDOObject((EObject)element);
            if (element != null) {
                CDOUtils.lock((CDOObject)cdo);
                this.updateAppearance(cdo);
                for (View next : PapyrusGMFEditorSupport.getViewsOfElement(element)) {
                    cdo = CDOUtils.getCDOObject((EObject)next);
                    if (cdo == null) continue;
                    CDOUtils.lock((CDOObject)cdo);
                    this.updateAppearance(cdo);
                }
                this.refresh();
            }
        }
    }

    private void updateAppearance(CDOObject cdoObject) {
        EObject element = CDOUtil.getEObject((EObject)cdoObject);
        DawnElementStylizer stylizer = DawnElementStylizerRegistry.instance.getStylizer((Object)element);
        if (stylizer != null) {
            if (cdoObject.cdoConflict()) {
                stylizer.setConflicted((Object)element, 2);
            } else if (CDOUtils.isLocked((CDOObject)cdoObject, (boolean)true)) {
                stylizer.setLocked((Object)element, 4);
            } else if (CDOUtils.isLocked((CDOObject)cdoObject, (boolean)false)) {
                stylizer.setLocked((Object)element, 3);
            } else {
                stylizer.setDefault((Object)element);
            }
        }
    }

    public void unlockObject(Object objectToBeUnlocked) {
        if (objectToBeUnlocked instanceof EditPart) {
            super.unlockObject(objectToBeUnlocked);
            CDOObject cdo = CDOUtils.getCDOObject((EObject)PapyrusGMFEditorSupport.getSemanticElement((EditPart)objectToBeUnlocked));
            if (cdo != null) {
                this.updateAppearance(cdo);
            }
        } else {
            CDOObject cdo;
            EObject element = EMFHelper.getEObject((Object)objectToBeUnlocked);
            CDOObject cDOObject = cdo = element == null ? null : CDOUtils.getCDOObject((EObject)element);
            if (element != null) {
                CDOUtils.unlock((CDOObject)cdo);
                this.updateAppearance(cdo);
                for (View next : PapyrusGMFEditorSupport.getViewsOfElement(element)) {
                    cdo = CDOUtils.getCDOObject((EObject)next);
                    if (cdo == null) continue;
                    CDOUtils.unlock((CDOObject)cdo);
                    this.updateAppearance(cdo);
                }
                this.refresh();
            }
        }
    }

    public void handleRemoteLockChanges(Map<Object, DawnState> changedObjects) {
        Map<Object, DawnState> filtered;
        if (UIUtil.ensureUIThread((Object)this, changedObjects) && (filtered = this.filter(changedObjects)) != null) {
            super.handleRemoteLockChanges(filtered);
        }
    }

    protected Map<Object, DawnState> filter(Map<Object, DawnState> changedObjects) {
        HashMap result = Maps.newHashMap(changedObjects);
        if (PapyrusGMFEditorSupport.filter(result.keySet(), PapyrusGMFEditorSupport.getDiagramEditor((IDawnEditor)this.getEditor())) && result.isEmpty()) {
            result = null;
        }
        return result;
    }

    public static View findView(DiagramDocumentEditor diagramEditor, EObject element) {
        View result;
        block2: {
            Diagram diagram;
            block1: {
                result = null;
                diagram = diagramEditor.getDiagram();
                View view = DawnDiagramUpdater.findViewByContainer((EObject)element);
                if (view == null) break block1;
                if (!EcoreUtil.isAncestor((EObject)diagram, (EObject)view)) break block2;
                result = view;
                break block2;
            }
            for (View next : PapyrusGMFEditorSupport.getViewsOfElement(element)) {
                if (!EcoreUtil.isAncestor((EObject)diagram, (EObject)next)) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    public static Iterable<View> getViewsOfElement(EObject element) {
        Iterable<Object> result = Collections.emptyList();
        ECrossReferenceAdapter xrefs = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)element);
        if (xrefs != null) {
            Collection settings = xrefs.getNonNavigableInverseReferences(element);
            result = Iterables.transform((Iterable)Iterables.filter((Iterable)settings, IS_VIEW_REFERENCE), OWNER_VIEW);
        }
        return result;
    }

    static boolean filter(Collection<?> objects, DiagramDocumentEditor diagramEditor) {
        boolean result = false;
        Iterator<?> iter = objects.iterator();
        while (iter.hasNext()) {
            EObject element;
            View view;
            Object next = iter.next();
            if (!(next instanceof CDOObject) || (view = PapyrusGMFEditorSupport.findView(diagramEditor, element = CDOUtil.getEObject((EObject)((CDOObject)next)))) != null) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    public static EObject getSemanticElement(EditPart editPart) {
        View view;
        EObject result = null;
        Object model = editPart.getModel();
        if (model instanceof EObject && (view = DawnDiagramUpdater.findViewByContainer((EObject)((EObject)model))) != null) {
            result = view.getElement();
        }
        return result;
    }
}

