/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.editors;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.transaction.CDOTransactionConflictEvent;
import org.eclipse.emf.cdo.transaction.CDOTransactionFinishedEvent;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.cdo.view.CDOViewLocksChangedEvent;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.papyrus.cdo.core.resource.CDOUndoContext;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateAdapter;
import org.eclipse.papyrus.cdo.internal.ui.decorators.CDOStateLabelDecorator;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.util.UIUtil;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusTransactionListener
implements IListener {
    private final ServicesRegistry services;
    private final Predicate<Adapter> shouldPropagate = new Predicate<Adapter>(){

        public boolean apply(Adapter input) {
            return input instanceof ECrossReferenceAdapter || input instanceof EContentAdapter || input instanceof ChangeRecorder;
        }
    };
    private final Set<Adapter> contentAdapters;

    public PapyrusTransactionListener(ServicesRegistry services, ResourceSet resourceSet) {
        this.services = services;
        this.contentAdapters = Sets.newHashSet((Iterable)Iterables.filter((Iterable)resourceSet.eAdapters(), this.shouldPropagate));
        ((BasicNotifierImpl.EObservableAdapterList)resourceSet.eAdapters()).addListener(new BasicNotifierImpl.EObservableAdapterList.Listener(){

            public void added(Notifier notifier, Adapter adapter) {
                if (adapter instanceof EContentAdapter) {
                    PapyrusTransactionListener.this.contentAdapters.add(adapter);
                }
            }

            public void removed(Notifier notifier, Adapter adapter) {
                PapyrusTransactionListener.this.contentAdapters.remove(adapter);
            }
        });
    }

    public void notifyEvent(IEvent event) {
        if (event instanceof CDOViewInvalidationEvent) {
            this.handleViewInvalidationEvent((CDOViewInvalidationEvent)event);
        } else if (event instanceof CDOTransactionConflictEvent) {
            this.handleTransactionConflictEvent((CDOTransactionConflictEvent)event);
        } else if (event instanceof CDOViewLocksChangedEvent) {
            this.handleLocksChangedEvent((CDOViewLocksChangedEvent)event);
        } else if (event instanceof CDOTransactionFinishedEvent) {
            this.handleTransactionFinishedEvent((CDOTransactionFinishedEvent)event);
        } else {
            this.handleEvent(event);
        }
    }

    protected void handleTransactionConflictEvent(CDOTransactionConflictEvent event) {
        CDOObject cdoObject;
        EObject element;
        View view;
        if (UIUtil.ensureUIThread(this, event) && (view = DawnDiagramUpdater.findViewByContainer((EObject)(element = CDOUtil.getEObject((EObject)(cdoObject = event.getConflictingObject()))))) == null && cdoObject.cdoConflict()) {
            CDOStateAdapter.setState((Notifier)element, DawnState.CONFLICT);
            CDOStateLabelDecorator.fireLabelUpdates();
        }
    }

    protected void handleLocksChangedEvent(CDOViewLocksChangedEvent event) {
        if (UIUtil.ensureUIThread(this, event)) {
            HashMap<EObject, DawnState> changedObjects = new HashMap<EObject, DawnState>();
            CDOView cdoView = event.getSource();
            CDOLockState[] cDOLockStateArray = event.getLockStates();
            int n = cDOLockStateArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOObject object;
                EObject element;
                View view;
                CDOID id;
                CDOLockState state = cDOLockStateArray[n2];
                Object lockedObject = state.getLockedObject();
                if (lockedObject instanceof CDOID) {
                    id = (CDOID)lockedObject;
                } else if (lockedObject instanceof CDOIDAndBranch) {
                    id = ((CDOIDAndBranch)lockedObject).getID();
                } else {
                    throw new RuntimeException("Unexpected object type: " + lockedObject);
                }
                if (id != null && (view = DawnDiagramUpdater.findViewByContainer((EObject)(element = CDOUtil.getEObject((EObject)(object = cdoView.getObject(id)))))) == null) {
                    if (CDOUtils.isLocked((CDOObject)object, (boolean)false)) {
                        throw new IllegalStateException("Locally locked objects should not occur.");
                    }
                    if (CDOUtils.isLocked((CDOObject)object, (boolean)true)) {
                        changedObjects.put(element, DawnState.LOCKED_REMOTELY);
                    } else {
                        changedObjects.put(element, DawnState.CLEAN);
                    }
                }
                ++n2;
            }
            this.handleLocks(changedObjects);
        }
    }

    void handleLocks(Map<EObject, DawnState> changedObjects) {
        if (!changedObjects.isEmpty()) {
            for (Map.Entry<EObject, DawnState> next : changedObjects.entrySet()) {
                EObject element = next.getKey();
                DawnState state = next.getValue();
                CDOStateAdapter.setState((Notifier)element, state);
            }
            CDOStateLabelDecorator.fireLabelUpdates();
        }
    }

    protected void handleViewInvalidationEvent(CDOViewInvalidationEvent event) {
        if (UIUtil.ensureUIThread(this, event)) {
            for (EObject next : CDOUtils.getEObjects((Iterable)event.getDirtyObjects())) {
                for (EObject possiblyNew : next.eContents()) {
                    this.synchronizeAdapters(possiblyNew);
                }
            }
            this.handleOperationHistory(event);
        }
    }

    protected void synchronizeAdapters(EObject object) {
        object.eAdapters().addAll((Collection)Sets.difference(this.contentAdapters, (Set)ImmutableSet.copyOf((Collection)object.eAdapters())));
    }

    protected void handleOperationHistory(CDOViewInvalidationEvent event) {
        CDOUndoContext context;
        Iterable affectedObjects;
        IOperationHistory history = this.getOperationHistory();
        if (history != null && !Iterables.isEmpty((Iterable)(affectedObjects = CDOUtils.getEObjects((Iterable)Iterables.concat((Iterable)event.getDirtyObjects(), (Iterable)event.getDetachedObjects())))) && (context = new CDOUndoContext(affectedObjects)) != null) {
            IUndoableOperation undoOperation = history.getUndoOperation((IUndoContext)context);
            IUndoableOperation redoOperation = history.getRedoOperation((IUndoContext)context);
            if (undoOperation != null || redoOperation != null) {
                if (undoOperation != null) {
                    history.operationChanged(undoOperation);
                }
                if (redoOperation != null) {
                    history.operationChanged(redoOperation);
                }
                history.dispose(this.getEditorUndoContext(), true, true, false);
                NotificationBuilder.createAsyncPopup((String)Messages.PapyrusTransactionListener_0).setType(Type.INFO).run();
            }
        }
    }

    protected IOperationHistory getOperationHistory() {
        IOperationHistory result = null;
        try {
            CommandStack stack;
            EditingDomain domain = (EditingDomain)this.services.getService(TransactionalEditingDomain.class);
            if (domain != null && (stack = domain.getCommandStack()) instanceof IWorkspaceCommandStack) {
                result = ((IWorkspaceCommandStack)stack).getOperationHistory();
            }
        }
        catch (ServiceException e) {
            Activator.log.error("Failed to get editor operation history from service registry.", (Throwable)e);
        }
        return result;
    }

    protected IUndoContext getEditorUndoContext() {
        IUndoContext result = null;
        try {
            result = (IUndoContext)this.services.getService(IUndoContext.class);
        }
        catch (ServiceException e) {
            Activator.log.error("Failed to get editor undo context from service registry.", (Throwable)e);
        }
        return result;
    }

    protected void handleTransactionFinishedEvent(CDOTransactionFinishedEvent event) {
        HashMap stateUpdates = Maps.newHashMap();
        for (CDOStateAdapter cDOStateAdapter : CDOStateAdapter.getAll(event.getSource().getResourceSet())) {
            Notifier target = cDOStateAdapter.getTarget();
            if (!(target instanceof EObject)) continue;
            EObject object = (EObject)target;
            stateUpdates.put(object, CDOUtils.computeState((EObject)object));
        }
        for (Map.Entry entry : stateUpdates.entrySet()) {
            CDOStateAdapter.setState((Notifier)entry.getKey(), (DawnState)entry.getValue());
        }
        CDOStateLabelDecorator.fireLabelUpdates();
    }

    protected void handleEvent(IEvent event) {
    }
}

