/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.handlers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelExportWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportModelHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event)) != null) {
            ExportModelHandler.exportModels(window, null, (IStructuredSelection)selection);
        }
        return null;
    }

    public static void exportModels(IWorkbenchWindow window, IContainer destination, IStructuredSelection selection) {
        ModelExportWizard wizard = new ModelExportWizard();
        wizard.init(window.getWorkbench(), selection);
        wizard.setInitialDestination(destination);
        new WizardDialog(window.getShell(), (IWizard)wizard).open();
    }

    public static void exportModels(IContainer destination, Iterable<URI> resourceURIs) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ArrayList models = Lists.newArrayList();
        for (URI next : resourceURIs) {
            Resource resource;
            CDOView view;
            IPapyrusRepository repo = PapyrusRepositoryManager.INSTANCE.getRepositoryForURI(next);
            if (repo == null || (view = ((IInternalPapyrusRepository)repo).getMasterView()) == null || !((resource = view.getResourceSet().getResource(next, true)) instanceof CDOResource)) continue;
            models.add(DIModel.getInstance((CDOResource)resource, true));
        }
        if (window != null && !models.isEmpty()) {
            ExportModelHandler.exportModels(window, destination, (IStructuredSelection)new StructuredSelection((List)models));
        }
    }
}

