/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.markers;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.markers.CDOPapyrusMarker;
import org.eclipse.papyrus.cdo.validation.problems.EProblem;
import org.eclipse.papyrus.cdo.validation.problems.edit.ProblemEditUtil;
import org.eclipse.papyrus.cdo.validation.problems.util.ProblemsManager;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.providers.AbstractMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMarkerProvider
extends AbstractMarkerProvider {
    private final ProblemEditUtil defaultUtil = new ProblemEditUtil((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));

    public boolean canProvideMarkersFor(Resource resource) {
        return resource instanceof CDOResource;
    }

    public Collection<? extends IPapyrusMarker> getMarkers(final Resource resource, final String type, final boolean includeSubtypes) throws CoreException {
        return (Collection)CDOMarkerProvider.run(resource, CoreException.class, new RunnableWithResult.Impl<Collection<? extends IPapyrusMarker>>(){

            public void run() {
                this.setResult(Lists.newArrayList((Iterator)Iterators.transform(CDOMarkerProvider.this.getProblems(resource, type, includeSubtypes), CDOPapyrusMarker.wrap(CDOMarkerProvider.this.getProblemEditUtil(resource)))));
            }
        });
    }

    protected Iterator<? extends EProblem> getProblems(Resource resource, final String type, boolean includeSubtypes) {
        Predicate<EProblem> filter = type == null ? Predicates.alwaysTrue() : (includeSubtypes ? new Predicate<EProblem>(){

            public boolean apply(EProblem input) {
                return MarkerListenerUtils.isMarkerTypeSubtypeOf((String)input.getType(), (String)type);
            }
        } : new Predicate<EProblem>(){

            public boolean apply(EProblem input) {
                return type.equals(input.getType());
            }
        });
        return Iterators.filter((Iterator)this.getProblemsManager(resource).getAllProblems(resource), (Predicate)filter);
    }

    public void createMarkers(final Resource resource, final Diagnostic diagnostic, final IProgressMonitor monitor) throws CoreException {
        CDOMarkerProvider.run(resource, CoreException.class, new Runnable(){

            public void run() {
                try {
                    CDOMarkerProvider.this.basicCreateMarkers(resource, diagnostic, monitor);
                }
                catch (CoreException e) {
                    throw new WrappedException((Exception)((Object)e));
                }
            }
        });
    }

    final void basicCreateMarkers(Resource resource, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        super.createMarkers(resource, diagnostic, monitor);
    }

    protected void doCreateMarker(Resource resource, Diagnostic diagnostic) throws CoreException {
        ProblemsManager mgr = this.getProblemsManager(resource);
        EProblem problem = mgr.createProblem(diagnostic);
        if (problem != null) {
            mgr.addProblem(problem);
        }
    }

    protected void batchCreated(Resource resource) {
        super.batchCreated(resource);
        ResourceSet rset = resource.getResourceSet();
        if (rset instanceof ModelSet) {
            ((ModelSet)rset).getTransactionalEditingDomain().yield();
        }
    }

    public void deleteMarkers(final EObject object, final IProgressMonitor monitor, final String type, final boolean includeSubtypes) throws CoreException {
        CDOMarkerProvider.run(object.eResource(), CoreException.class, new Runnable(){

            public void run() {
                try {
                    CDOMarkerProvider.this.basicDeleteMarkers(object, monitor, type, includeSubtypes);
                }
                catch (CoreException e) {
                    throw new WrappedException((Exception)((Object)e));
                }
            }
        });
    }

    protected final void basicDeleteMarkers(EObject object, IProgressMonitor monitor, String type, boolean includeSubtypes) throws CoreException {
        super.deleteMarkers(object, monitor, type, includeSubtypes);
    }

    public void deleteMarkers(Resource resource, IProgressMonitor monitor) {
        try {
            this.deleteMarkers(resource, monitor, null, true);
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public void deleteMarkers(final Resource resource, IProgressMonitor monitor, final String markerType, final boolean includeSubtypes) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        CDOMarkerProvider.run(resource, new Runnable(){

            public void run() {
                ProblemsManager mgr = CDOMarkerProvider.this.getProblemsManager(resource);
                if (markerType == null) {
                    mgr.purgeProblems(resource);
                } else {
                    for (EProblem next : Lists.newArrayList(CDOMarkerProvider.this.getProblems(resource, markerType, includeSubtypes))) {
                        ProblemsManager.delete((EProblem)next);
                    }
                }
            }
        });
        sub.done();
    }

    private ProblemsManager getProblemsManager(Resource resource) {
        return ProblemsManager.getProblemsManager((ResourceSet)resource.getResourceSet());
    }

    private ProblemEditUtil getProblemEditUtil(Resource resource) {
        ProblemEditUtil result = this.defaultUtil;
        ResourceSet rset = resource.getResourceSet();
        if (rset instanceof ModelSet) {
            AdapterFactory factory = ((AdapterFactoryEditingDomain)((ModelSet)rset).getTransactionalEditingDomain()).getAdapterFactory();
            result = new ProblemEditUtil(factory);
        }
        return result;
    }

    static <X extends Throwable> void run(Resource context, Runnable runnable) {
        CDOMarkerProvider.run(context, RuntimeException.class, runnable);
    }

    static <X extends Throwable> void run(Resource context, Class<X> exceptionType, Runnable runnable) throws X {
        ResourceSet rset = context.getResourceSet();
        if (rset instanceof ModelSet) {
            try {
                ((ModelSet)rset).getTransactionalEditingDomain().runExclusive(runnable);
            }
            catch (WrappedException e) {
                throw (Throwable)exceptionType.cast(e.exception());
            }
            catch (InterruptedException e) {
                Activator.log.error("CDO problem markers runnable interrupted.", (Throwable)e);
            }
        } else {
            runnable.run();
        }
    }

    static <T, X extends Throwable> T run(Resource context, Class<X> exceptionType, RunnableWithResult<T> runnable) throws X {
        Object result;
        ResourceSet rset = context.getResourceSet();
        if (rset instanceof ModelSet) {
            try {
                result = TransactionUtil.runExclusive((TransactionalEditingDomain)((ModelSet)rset).getTransactionalEditingDomain(), runnable);
            }
            catch (WrappedException e) {
                throw (Throwable)exceptionType.cast(e.exception());
            }
            catch (InterruptedException e) {
                Activator.log.error("CDO problem markers runnable interrupted.", (Throwable)e);
                result = null;
            }
        } else {
            runnable.run();
            result = runnable.getResult();
        }
        return (T)result;
    }
}

