/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.properties;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RepositoryPropertiesBlock
extends Notifier {
    private Text nameText;
    private ComboViewer protocolCombo;
    private Button defaultPort;
    private Text portText;
    private Text hostText;
    private Text repoText;
    private String name;
    private String url;
    private IStatus status = Status.OK_STATUS;
    private IPapyrusRepository repository;
    private boolean createMode;
    private boolean editable = true;

    public RepositoryPropertiesBlock() {
        this(null, true);
    }

    public RepositoryPropertiesBlock(IPapyrusRepository repository) {
        this(repository, false);
    }

    private RepositoryPropertiesBlock(IPapyrusRepository repository, boolean createMode) {
        this.repository = repository;
        this.createMode = createMode;
    }

    public Control createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)result);
        new Label(result, 0).setText(Messages.RepositoryPropertiesBlock_0);
        this.nameText = new Text(result, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        new Label(result, 0).setText(Messages.RepositoryPropertiesBlock_1);
        this.protocolCombo = new ComboViewer(result);
        this.protocolCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.protocolCombo.setInput((Object)Protocol.values());
        this.defaultPort = new Button(result, 32);
        this.defaultPort.setText(Messages.RepositoryPropertiesBlock_2);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.defaultPort);
        Label label = new Label(result, 0);
        label.setText(Messages.RepositoryPropertiesBlock_3);
        GridDataFactory.swtDefaults().indent(15, 0).applyTo((Control)label);
        this.portText = new Text(result, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)this.portText);
        new Label(result, 0).setText(Messages.RepositoryPropertiesBlock_4);
        this.hostText = new Text(result, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)this.hostText);
        new Label(result, 0).setText(Messages.RepositoryPropertiesBlock_5);
        this.repoText = new Text(result, 2048);
        GridDataFactory.fillDefaults().applyTo((Control)this.repoText);
        this.reset();
        this.defaultPort.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPropertiesBlock.this.portText.setEnabled(!RepositoryPropertiesBlock.this.defaultPort.getSelection());
                if (RepositoryPropertiesBlock.this.defaultPort.getSelection()) {
                    RepositoryPropertiesBlock.this.updatePortForProtocol();
                    RepositoryPropertiesBlock.this.recalculateURL();
                }
            }
        });
        this.protocolCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (RepositoryPropertiesBlock.this.defaultPort.getSelection()) {
                    RepositoryPropertiesBlock.this.updatePortForProtocol();
                    RepositoryPropertiesBlock.this.recalculateURL();
                }
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryPropertiesBlock.this.recalculateURL();
            }
        };
        this.nameText.addModifyListener(modifyListener);
        this.portText.addModifyListener(modifyListener);
        this.hostText.addModifyListener(modifyListener);
        this.repoText.addModifyListener(modifyListener);
        this.updateEditable();
        return result;
    }

    public void dispose() {
    }

    public void reset() {
        String name;
        if (this.nameText == null) {
            return;
        }
        String string = this.repository == null ? (this.createMode ? Messages.RepositoryPropertiesBlock_6 : "") : (name = this.repository.getName());
        String url = this.repository == null ? (this.createMode ? "tcp://localhost?repositoryName=repo1" : null) : this.repository.getURL();
        URI uri = url == null ? null : URI.createURI((String)url);
        String host = uri == null ? "" : this.parseHost(uri);
        String repo = uri == null ? "" : this.parseRepositoryName(uri);
        Protocol protocol = Protocol.TCP;
        String portString = "";
        boolean isDefaultPort = true;
        if (uri != null) {
            protocol = Protocol.valueOf(uri.scheme().toUpperCase());
            int port = this.parsePort(uri);
            if (port < 0) {
                port = this.getSelectedProtocol().defaultPort();
            }
            portString = Integer.toString(port);
            isDefaultPort = port == this.getSelectedProtocol().defaultPort();
        }
        this.nameText.setText(name);
        this.protocolCombo.setSelection((ISelection)new StructuredSelection((Object)protocol));
        this.hostText.setText(host);
        this.repoText.setText(repo);
        this.defaultPort.setSelection(isDefaultPort);
        this.portText.setEnabled(this.editable && !isDefaultPort);
        this.portText.setText(portString);
        this.updatePortForProtocol();
        this.recalculateURL();
    }

    public void setRepository(IPapyrusRepository repository) {
        if (this.repository != repository) {
            this.repository = repository;
            this.reset();
        }
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            this.editable = editable;
            this.updateEditable();
        }
    }

    Protocol getSelectedProtocol() {
        Protocol result = Protocol.TCP;
        IStructuredSelection sel = (IStructuredSelection)this.protocolCombo.getSelection();
        if (!sel.isEmpty()) {
            result = (Protocol)((Object)sel.getFirstElement());
        }
        return result;
    }

    void updatePortForProtocol() {
        this.portText.setText(String.valueOf(this.getSelectedProtocol().defaultPort()));
    }

    public void finish() {
        this.name = this.nameText.getText();
    }

    public void update() {
        this.recalculateURL();
    }

    void recalculateURL() {
        try {
            if (Integer.parseInt(this.portText.getText().trim()) <= 0) {
                throw new IllegalArgumentException();
            }
        }
        catch (Exception e) {
            this.setStatus(this.error(Messages.RepositoryPropertiesBlock_12));
            return;
        }
        if (this.hostText.getText().trim().length() == 0) {
            this.setStatus(this.error(Messages.RepositoryPropertiesBlock_13));
            return;
        }
        if (this.repoText.getText().trim().length() == 0) {
            this.setStatus(this.error(Messages.RepositoryPropertiesBlock_14));
            return;
        }
        if (this.nameText.getText().trim().length() == 0) {
            this.setStatus(this.error(Messages.RepositoryPropertiesBlock_15));
            return;
        }
        this.name = this.nameText.getText().trim();
        this.url = this.computeURL();
        IPapyrusRepository existing = PapyrusRepositoryManager.INSTANCE.getRepository(this.url);
        if (existing != null && existing != this.repository) {
            this.setStatus(this.error(NLS.bind((String)Messages.RepositoryPropertiesBlock_16, (Object)existing.getName())));
            return;
        }
        for (IPapyrusRepository next : PapyrusRepositoryManager.INSTANCE.getRepositories()) {
            if (next == this.repository || !Objects.equal((Object)next.getName(), (Object)this.name)) continue;
            this.setStatus(this.warning(NLS.bind((String)Messages.RepositoryPropertiesBlock_17, (Object)next.getName())));
            return;
        }
        this.setStatus(Status.OK_STATUS);
    }

    private IStatus error(String reason) {
        return new Status(4, "org.eclipse.papyrus.cdo.ui", reason);
    }

    private IStatus warning(String reason) {
        return new Status(2, "org.eclipse.papyrus.cdo.ui", reason);
    }

    private String computeURL() {
        StringBuilder result = new StringBuilder();
        result.append(this.getSelectedProtocol().scheme).append(":");
        result.append("//");
        result.append(this.hostText.getText().trim());
        result.append(":").append(this.portText.getText().trim());
        result.append("?repositoryName=").append(this.repoText.getText().trim());
        return result.toString();
    }

    private int parsePort(URI uri) {
        String result = uri.port();
        return result == null ? -1 : Integer.parseInt(result);
    }

    private String parseHost(URI uri) {
        int colon;
        String result = uri.authority();
        if (result != null && (colon = result.lastIndexOf(58)) >= 0) {
            result = result.substring(0, colon);
        }
        return result;
    }

    private String parseRepositoryName(URI uri) {
        return (String)CDOURIUtil.getParameters((String)uri.query()).get("repositoryName");
    }

    public IStatus getStatus() {
        return this.status;
    }

    void setStatus(IStatus status) {
        this.status = status;
        class StatusChangedEvent
        extends Event
        implements IStatusChangedEvent {
            private static final long serialVersionUID = 1L;
            private final /* synthetic */ IStatus val$status;

            StatusChangedEvent(IStatus iStatus) {
                this.val$status = iStatus;
                super((INotifier)RepositoryPropertiesBlock.this);
            }

            public IStatus getStatus() {
                return this.val$status;
            }
        }
        this.fireEvent(new StatusChangedEvent(status));
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.url;
    }

    private void updateEditable() {
        if (this.nameText == null) {
            return;
        }
        this.nameText.setEnabled(this.editable);
        this.protocolCombo.getControl().setEnabled(this.editable);
        this.defaultPort.setEnabled(this.editable);
        this.portText.setEnabled(this.editable && !this.defaultPort.getSelection());
        this.hostText.setEnabled(this.editable);
        this.repoText.setEnabled(this.editable);
    }

    public static interface IStatusChangedEvent
    extends IEvent {
        public IStatus getStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        TCP("tcp", 2036),
        HTTP("http", 80);

        private final String scheme;
        private final int defaultPort;

        private Protocol(String scheme, int defaultPort) {
            this.scheme = scheme;
            this.defaultPort = defaultPort;
        }

        public String scheme() {
            return this.scheme;
        }

        public int defaultPort() {
            return this.defaultPort;
        }
    }

    public static class StatusChangedEventAdapter
    implements IListener {
        public void notifyEvent(IEvent event) {
            if (event instanceof IStatusChangedEvent) {
                this.handleStatusChanged((RepositoryPropertiesBlock)event.getSource(), ((IStatusChangedEvent)event).getStatus());
            } else {
                this.handleOtherEvent(event);
            }
        }

        protected void handleStatusChanged(RepositoryPropertiesBlock source, IStatus newStatus) {
        }

        protected void handleOtherEvent(IEvent event) {
        }
    }

    public static class StatusChangedMessageProviderAdapter
    extends StatusChangedEventAdapter {
        protected void handleStatusChanged(RepositoryPropertiesBlock source, IStatus newStatus) {
            int messageSeverity;
            switch (newStatus.getSeverity()) {
                case 0: {
                    messageSeverity = 0;
                    break;
                }
                case 1: {
                    messageSeverity = 1;
                    break;
                }
                case 2: {
                    messageSeverity = 2;
                    break;
                }
                default: {
                    messageSeverity = 3;
                }
            }
            this.handleMessageChange(newStatus.isOK() ? null : newStatus.getMessage(), messageSeverity);
        }

        protected void handleMessageChange(String message, int messageSeverity) {
        }
    }
}

