/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.properties;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.cdo.core.CommitException;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.properties.RepositoryPropertiesBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class RepositoryPropertyPage
extends PropertyPage {
    private static final String MESSAGE = Messages.RepositoryPropertyPage_0;
    private RepositoryPropertiesBlock block;
    private Button forgetCredsButton;

    protected Control createContents(Composite parent) {
        this.setMessage(MESSAGE);
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(1, false));
        this.block = new RepositoryPropertiesBlock(this.getRepository());
        this.block.createControl(result);
        this.block.addListener(new RepositoryPropertiesBlock.StatusChangedMessageProviderAdapter(){

            protected void handleMessageChange(String message, int messageSeverity) {
                RepositoryPropertyPage.this.setValid(messageSeverity < 3);
                if (message == null) {
                    RepositoryPropertyPage.this.setMessage(MESSAGE);
                } else {
                    RepositoryPropertyPage.this.setMessage(message, messageSeverity);
                }
            }
        });
        this.forgetCredsButton = new Button(result, 8);
        this.forgetCredsButton.setText(Messages.RepositoryPropertyPage_1);
        this.forgetCredsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoryPropertyPage.this.getRepository().clearCredentials();
            }
        });
        return result;
    }

    protected IPapyrusRepository getRepository() {
        IAdaptable element = this.getElement();
        IPapyrusRepository result = element instanceof IPapyrusRepository ? (IPapyrusRepository)element : (IPapyrusRepository)element.getAdapter(IPapyrusRepository.class);
        return result;
    }

    public boolean performOk() {
        IPapyrusRepository repository;
        boolean result = false;
        this.block.finish();
        if (this.block.getStatus().isOK() && (!(repository = this.getRepository()).isConnected() || Objects.equal((Object)repository.getURL(), (Object)this.block.getURL()) || MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.RepositoryPropertyPage_2, (String)Messages.RepositoryPropertyPage_3))) {
            this.updateRepository(repository);
            result = super.performOk();
        }
        return result;
    }

    protected void performDefaults() {
        this.block.reset();
    }

    private void updateRepository(IPapyrusRepository repository) {
        boolean reconnect = repository.isConnected() && !Objects.equal((Object)repository.getURL(), (Object)this.block.getURL());
        PapyrusRepositoryManager mgr = PapyrusRepositoryManager.INSTANCE;
        String url = this.block.getURL();
        try {
            if (reconnect) {
                repository.disconnect();
            }
            repository.setName(this.block.getName());
            mgr.setURL(repository, url);
            mgr.saveRepositories();
            if (reconnect) {
                repository.connect();
            }
        }
        catch (CommitException e) {
            StatusAdapter adapter = new StatusAdapter(e.getStatus());
            adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)Messages.RepositoryPropertyPage_4);
            StatusManager.getManager().handle(adapter, 2);
        }
    }
}

