/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.util;

import com.google.common.base.Strings;
import java.util.concurrent.Callable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider2;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.ICredentialsProviderFactory;
import org.eclipse.papyrus.cdo.internal.core.IInteractiveCredentialsProvider;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.papyrus.cdo.internal.ui.dialogs.RepositoryCredentialsDialog;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DialogCredentialsProviderFactory
implements ICredentialsProviderFactory {
    private volatile IWorkbenchWindow activeWindow;

    public DialogCredentialsProviderFactory() {
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
                DialogCredentialsProviderFactory.this.activeWindow = window;
            }

            public void windowClosed(IWorkbenchWindow window) {
                if (DialogCredentialsProviderFactory.this.activeWindow == window) {
                    DialogCredentialsProviderFactory.this.activeWindow = null;
                }
            }

            public void windowOpened(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }
        });
    }

    public IPasswordCredentialsProvider2 createCredentialsProvider(IPapyrusRepository repository) {
        return new CredentialsProvider(repository);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CredentialsProvider
    implements IInteractiveCredentialsProvider {
        private IPapyrusRepository repository;

        CredentialsProvider(IPapyrusRepository repository) {
            this.repository = repository;
        }

        public boolean isInteractive() {
            return true;
        }

        public IPasswordCredentials getCredentials() {
            return this.getCredentials(null);
        }

        public IPasswordCredentials getCredentials(String realm) {
            String username = this.repository.getUsername();
            String password = this.repository.getPassword();
            Object result = !Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password) ? new PasswordCredentials(username, password.toCharArray()) : this.call(new Callable<IPasswordCredentials>(){

                @Override
                public IPasswordCredentials call() {
                    return CredentialsProvider.this.openDialog();
                }
            });
            return result;
        }

        private Shell getCurrentShell() {
            return DialogCredentialsProviderFactory.this.activeWindow != null ? DialogCredentialsProviderFactory.this.activeWindow.getShell() : Display.getDefault().getActiveShell();
        }

        private IPasswordCredentials openDialog() {
            IPasswordCredentials result = null;
            RepositoryCredentialsDialog dlg = new RepositoryCredentialsDialog(this.getCurrentShell(), this.repository);
            if (dlg.open() == 0) {
                result = dlg.getCredentials();
            }
            return result;
        }

        public void reportCredentialsFailure(final SecurityException e) {
            this.call(new Callable<Void>(){

                @Override
                public Void call() {
                    MessageDialog.openWarning((Shell)CredentialsProvider.this.getCurrentShell(), (String)Messages.DialogCredentialsProviderFactory_0, (String)e.getLocalizedMessage());
                    return null;
                }
            });
        }

        private <T> T call(final Callable<T> callable) {
            final Object[] result = new Object[1];
            Shell parentShell = this.getCurrentShell();
            if (parentShell.getDisplay() == Display.getCurrent()) {
                try {
                    result[0] = callable.call();
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            } else {
                parentShell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            result[0] = callable.call();
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                });
            }
            Object resultAsT = result[0];
            return (T)resultAsT;
        }
    }
}

