/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.util;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.papyrus.cdo.internal.ui.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUtil {
    private UIUtil() {
    }

    public static Executor uiSafeExecutor() {
        return UISafeExecutor.INSTANCE;
    }

    public static void later(Runnable runnable) {
        DisplayUtils.getDisplay().asyncExec(runnable);
    }

    public static <T> Future<T> asyncCall(Display display, Callable<T> callable) {
        FutureTask<T> result = new FutureTask<T>(callable);
        display.asyncExec(result);
        return result;
    }

    public static <T> Future<T> call(Callable<T> callable) {
        FutureTask<T> result = new FutureTask<T>(callable);
        Display display = Display.getCurrent();
        if (display != null) {
            result.run();
        } else {
            DisplayUtils.getDisplay().asyncExec(result);
        }
        return result;
    }

    public static boolean ensureUIThread(final Object receiver, final Object ... arguments) {
        boolean result;
        Display display = DisplayUtils.getDisplay();
        boolean bl = result = Display.getCurrent() == display;
        if (!result) {
            String callingMethodName = null;
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            int i = 0;
            while (i < stack.length) {
                StackTraceElement next = stack[i];
                if (UIUtil.class.getName().equals(next.getClassName()) && "ensureUIThread".equals(next.getMethodName())) {
                    callingMethodName = stack[i + 1].getMethodName();
                    break;
                }
                ++i;
            }
            if (callingMethodName == null) {
                throw new IllegalStateException("Invalid stack trace");
            }
            final Method method = UIUtil.findMethod(receiver.getClass(), callingMethodName, arguments);
            if (method == null) {
                throw new IllegalStateException("Could not find calling method");
            }
            method.setAccessible(true);
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        method.invoke(receiver, arguments);
                    }
                    catch (Exception e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            });
        }
        return result;
    }

    private static Method findMethod(Class<?> owner, String name, Object[] arguments) {
        Method result = null;
        Class[] actual = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            actual[i] = arguments[i] == null ? null : arguments[i].getClass();
            ++i;
        }
        Method[] declared = owner.getDeclaredMethods();
        int i2 = 0;
        while (i2 < declared.length) {
            block5: {
                Method next = declared[i2];
                if (name.equals(next.getName())) {
                    Class<?>[] parameters = next.getParameterTypes();
                    int j = 0;
                    while (j < parameters.length) {
                        if (actual[j] == null || parameters[j].isAssignableFrom(actual[j])) {
                            ++j;
                            continue;
                        }
                        break block5;
                    }
                    result = next;
                    break;
                }
            }
            ++i2;
        }
        return result;
    }

    private static final class UISafeExecutor
    implements Executor {
        static final UISafeExecutor INSTANCE = new UISafeExecutor();

        private UISafeExecutor() {
        }

        public void execute(Runnable command) {
            Display workbenchDisplay = PlatformUI.getWorkbench().getDisplay();
            if (Display.getCurrent() == workbenchDisplay) {
                command.run();
            } else {
                workbenchDisplay.asyncExec(command);
            }
        }
    }
}

