/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.views;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.cdo.internal.ui.SharedImages;
import org.eclipse.swt.graphics.Image;

public class DIModel
extends PlatformObject
implements Adapter {
    private final CDOResource resource;

    public DIModel(CDOResource resource) {
        this.resource = resource;
        Iterator iter = resource.eAdapters().iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof DIModel)) continue;
            iter.remove();
        }
        resource.eAdapters().add((Object)this);
    }

    public final CDOResource getResource() {
        return this.resource;
    }

    public static DIModel getInstance(CDOResource resource, boolean create) {
        DIModel result = (DIModel)EcoreUtil.getExistingAdapter((Notifier)resource, DIModel.class);
        if (result == null && create) {
            result = new DIModel(resource);
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == CDOResourceNode.class || adapter == CDOResource.class || adapter == CDOObject.class) {
            return this.getResource();
        }
        return super.getAdapter(adapter);
    }

    public String getName() {
        return this.resource.getURI().trimFileExtension().lastSegment();
    }

    public Image getImage() {
        return SharedImages.getImage("papyrus_model");
    }

    public Object[] getChildren() {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)3);
        String name = this.getName();
        if (name != null) {
            CDOResource root;
            CDOResourceFolder folder = this.getResource().getFolder();
            Object nodes = folder != null ? folder.getNodes() : ((root = this.getResource().cdoResource()) != null && root.isRoot() ? root.getContents() : Collections.emptyList());
            for (CDOResource next : Iterables.filter((Iterable)nodes, CDOResource.class)) {
                if (!name.equals(next.getURI().trimFileExtension().lastSegment())) continue;
                result.add(next);
            }
        }
        return result.toArray();
    }

    public void notifyChanged(Notification notification) {
    }

    public Notifier getTarget() {
        return this.resource;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return type == DIModel.class;
    }
}

