/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.views;

import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.ui.editors.PapyrusCDOEditorInput;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;

class LinkingHelper {
    private final IWorkbenchSite site;
    private final IPapyrusRepositoryManager repositoryManager;
    private final StructuredViewer viewer;
    private boolean linkWithEditor;
    private IPartListener linkingPartListener;
    private ISelectionChangedListener linkingSelectionListener;

    public LinkingHelper(IWorkbenchSite site, IPapyrusRepositoryManager repositoryManager, StructuredViewer viewer) {
        this.site = site;
        this.repositoryManager = repositoryManager;
        this.viewer = viewer;
    }

    public void dispose() {
        if (this.linkingPartListener != null) {
            this.site.getPage().removePartListener(this.linkingPartListener);
        }
        if (this.linkingSelectionListener != null) {
            this.viewer.removeSelectionChangedListener(this.linkingSelectionListener);
        }
    }

    public boolean isLinkWithEditor() {
        return this.linkWithEditor;
    }

    public void setLinkWithEditor(boolean link) {
        if (link != this.linkWithEditor) {
            this.linkWithEditor = link;
            if (link) {
                IWorkbenchPart active = this.site.getPage().getActivePart();
                if (active != null && active.getSite() == this.site) {
                    this.selectEditor();
                } else {
                    this.handleEditor(this.site.getPage().getActiveEditor());
                }
                this.site.getPage().addPartListener(this.getLinkingPartListener());
                this.viewer.addSelectionChangedListener(this.getLinkingSelectionListener());
            } else {
                this.site.getPage().removePartListener(this.getLinkingPartListener());
                this.viewer.removeSelectionChangedListener(this.getLinkingSelectionListener());
            }
        }
    }

    protected void selectEditor() {
        DIModel model = this.getDIModelFromSelection();
        if (model != null) {
            URI uri = model.getResource().getURI();
            PapyrusCDOEditorInput input = new PapyrusCDOEditorInput(uri);
            IEditorPart editor = this.site.getPage().findEditor((IEditorInput)input);
            if (editor != null) {
                this.site.getPage().activate((IWorkbenchPart)editor);
            }
        }
    }

    protected void handleEditor(IEditorPart activeEditor) {
        IEditorInput input;
        if (activeEditor != null && (input = activeEditor.getEditorInput()) instanceof URIEditorInput) {
            DIModel model;
            URI uri = ((URIEditorInput)input).getURI();
            DIModel selected = this.getDIModelFromSelection();
            if (!(selected != null && selected.getResource().getURI().equals(uri) || (model = this.findDIModel(uri)) == null)) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)model), true);
            }
        }
    }

    protected DIModel getDIModelFromSelection() {
        StructuredSelection sel = this.viewer == null ? StructuredSelection.EMPTY : (IStructuredSelection)this.viewer.getSelection();
        return sel.isEmpty() ? null : this.getDIModelFromSelection(sel.getFirstElement());
    }

    protected DIModel getDIModelFromSelection(Object selected) {
        Object parent;
        DIModel result = null;
        if (selected instanceof DIModel) {
            result = (DIModel)((Object)selected);
        } else if (selected instanceof CDOResource && (parent = ((ITreeContentProvider)this.viewer.getContentProvider()).getParent(selected)) instanceof DIModel) {
            result = (DIModel)((Object)parent);
        }
        return result;
    }

    protected DIModel findDIModel(URI uri) {
        Resource res;
        CDOView mainView;
        DIModel result = null;
        IInternalPapyrusRepository repo = (IInternalPapyrusRepository)this.repositoryManager.getRepositoryForURI(uri);
        if (repo != null && (mainView = repo.getMasterView()) != null && !mainView.isClosed() && (res = mainView.getResourceSet().getResource(uri, false)) instanceof CDOResource && res.isLoaded()) {
            result = DIModel.getInstance((CDOResource)res, true);
        }
        return result;
    }

    private IPartListener getLinkingPartListener() {
        if (this.linkingPartListener == null) {
            this.linkingPartListener = new IPartListener(){

                public void partActivated(IWorkbenchPart part) {
                    if (part instanceof IEditorPart) {
                        LinkingHelper.this.handleEditor((IEditorPart)part);
                    }
                }

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }
            };
        }
        return this.linkingPartListener;
    }

    private ISelectionChangedListener getLinkingSelectionListener() {
        if (this.linkingSelectionListener == null) {
            this.linkingSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    LinkingHelper.this.selectEditor();
                }
            };
        }
        return this.linkingSelectionListener;
    }
}

