/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.net4j.util.ui.views.ContainerView;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.actions.AbstractRepositoryAction;
import org.eclipse.papyrus.cdo.internal.ui.actions.AddRepositoryAction;
import org.eclipse.papyrus.cdo.internal.ui.actions.ConnectRepositoryAction;
import org.eclipse.papyrus.cdo.internal.ui.actions.CreateFolderAction;
import org.eclipse.papyrus.cdo.internal.ui.actions.DeleteModelAction;
import org.eclipse.papyrus.cdo.internal.ui.actions.DisconnectRepositoryAction;
import org.eclipse.papyrus.cdo.internal.ui.actions.LinkWithEditorAction;
import org.eclipse.papyrus.cdo.internal.ui.actions.OpenPapyrusModelAction;
import org.eclipse.papyrus.cdo.internal.ui.actions.RemoveRepositoryAction;
import org.eclipse.papyrus.cdo.internal.ui.actions.RenameModelAction;
import org.eclipse.papyrus.cdo.internal.ui.dnd.ResourceDragAdapter;
import org.eclipse.papyrus.cdo.internal.ui.dnd.ResourceDropAdapter;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.cdo.internal.ui.views.LinkingHelper;
import org.eclipse.papyrus.cdo.internal.ui.views.ModelRepositoryItemProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRepositoriesView
extends ContainerView {
    public static final String ID = "org.eclipse.papyrus.cdo.ui.ModelRepositoriesView";
    public static final int LINK_WITH_EDITOR_PROPERTY = 65536;
    private static final String STATE_LINKING = "linkWithEditor";
    private final IInternalPapyrusRepositoryManager repositoryManager = PapyrusRepositoryManager.INSTANCE;
    private AddRepositoryAction addRepositoryAction;
    private LinkWithEditorAction linkWithEditorAction;
    private AbstractRepositoryAction connectRepositoryAction;
    private AbstractRepositoryAction disconnectRepositoryAction;
    private RemoveRepositoryAction removeRepositoryAction;
    private OpenPapyrusModelAction openModelAction;
    private PropertyDialogAction propertyDialogAction;
    private CreateFolderAction createFolderAction;
    private RenameModelAction renameModelAction;
    private DeleteModelAction deleteModelAction;
    private boolean isLinkWithEditor;
    private LinkingHelper linkingHelper;

    protected IContainer<?> getContainer() {
        return (IContainer)this.repositoryManager;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        Boolean linking = memento == null ? Boolean.TRUE : memento.getBoolean(STATE_LINKING);
        this.setLinkWithEditor(!Boolean.FALSE.equals(linking));
    }

    public void saveState(IMemento memento) {
        memento.putBoolean(STATE_LINKING, this.isLinkWithEditor());
        super.saveState(memento);
    }

    public boolean isLinkWithEditor() {
        return this.isLinkWithEditor;
    }

    public void setLinkWithEditor(boolean link) {
        if (this.isLinkWithEditor != link) {
            this.isLinkWithEditor = link;
            if (this.linkingHelper != null) {
                this.linkingHelper.setLinkWithEditor(link);
            }
            this.firePropertyChange(65536);
        }
    }

    protected Control createUI(Composite parent) {
        this.createActions();
        Control result = super.createUI(parent);
        ResourceDragAdapter.install((StructuredViewer)this.getViewer());
        ResourceDropAdapter.install((StructuredViewer)this.getViewer()).setFeedbackEnabled(false);
        return result;
    }

    protected void createdUI() {
        super.createdUI();
        this.linkingHelper = new LinkingHelper((IWorkbenchSite)this.getSite(), (IPapyrusRepositoryManager)this.repositoryManager, (StructuredViewer)this.getViewer());
        this.linkingHelper.setLinkWithEditor(this.isLinkWithEditor());
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.openModelAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.connectRepositoryAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.disconnectRepositoryAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.removeRepositoryAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.createFolderAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.renameModelAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteModelAction);
        this.propertyDialogAction = new PropertyDialogAction((IShellProvider)this.getSite(), selectionProvider);
        this.propertyDialogAction.setActionDefinitionId("org.eclipse.ui.file.properties");
    }

    protected void createActions() {
        this.addRepositoryAction = new AddRepositoryAction((IWorkbenchPart)this);
        this.linkWithEditorAction = new LinkWithEditorAction(this);
        this.connectRepositoryAction = new ConnectRepositoryAction((IWorkbenchPart)this);
        this.disconnectRepositoryAction = new DisconnectRepositoryAction((IWorkbenchPart)this);
        this.removeRepositoryAction = new RemoveRepositoryAction((IWorkbenchPart)this);
        this.openModelAction = new OpenPapyrusModelAction((IWorkbenchPart)this);
        this.createFolderAction = new CreateFolderAction((IWorkbenchPart)this);
        this.renameModelAction = new RenameModelAction((IWorkbenchPart)this);
        this.deleteModelAction = new DeleteModelAction((IWorkbenchPart)this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameModelAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteModelAction);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        manager.add((IAction)this.linkWithEditorAction);
        super.fillLocalToolBar(manager);
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
        manager.add((IContributionItem)new GroupMarker("createActions"));
        if (!selection.isEmpty()) {
            Object selected = selection.getFirstElement();
            if (selected instanceof DIModel) {
                manager.add((IAction)this.openModelAction);
                manager.add((IAction)this.renameModelAction);
                manager.add((IAction)this.deleteModelAction);
            }
            if (selected instanceof IPapyrusRepository) {
                if (((IPapyrusRepository)selected).isConnected()) {
                    manager.add((IAction)this.createFolderAction);
                }
                manager.add((IAction)this.connectRepositoryAction);
                manager.add((IAction)this.disconnectRepositoryAction);
                manager.add((IAction)this.removeRepositoryAction);
                manager.add((IAction)this.propertyDialogAction);
            }
        }
        super.fillContextMenu(manager, selection);
    }

    protected void doubleClicked(Object object) {
        if (object instanceof DIModel) {
            this.invoke((Action)this.openModelAction);
        } else if (object instanceof IPapyrusRepository) {
            this.invoke((Action)this.connectRepositoryAction);
        } else {
            super.doubleClicked(object);
        }
    }

    protected void invoke(Action action) {
        if (action.isEnabled()) {
            action.run();
        }
    }

    protected ContainerItemProvider<IContainer<Object>> createContainerItemProvider() {
        return new ModelRepositoryItemProvider(this.getSite().getPage());
    }
}

