/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.views;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.net4j.util.ui.views.IElementFilter;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.ui.SharedImages;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.cdo.internal.ui.views.DIResourceQuery;
import org.eclipse.papyrus.cdo.internal.ui.views.ItemProviderFilterRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRepositoryItemProvider
extends CDOItemProvider {
    private final Predicate<Object> isDIResource = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input instanceof CDOResource && DIResourceQuery.getDIResources(((CDOResource)input).cdoView()).contains(input);
        }
    };
    private final Predicate<Object> isUnaffiliatedResource = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input instanceof CDOResource && DIResourceQuery.isUnaffiliatedResource((CDOResource)input);
        }
    };
    private final Predicate<Object> resourceFilter = Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(CDOResourceFolder.class), this.isDIResource, this.isUnaffiliatedResource});
    private final Function<Object, Object> resourceNodeTransformer = new Function<Object, Object>(){

        public Object apply(Object input) {
            if (ModelRepositoryItemProvider.this.isDIResource.apply(input)) {
                return DIModel.getInstance((CDOResource)input, true);
            }
            return input;
        }
    };
    private final Predicate<Object> extensibleFilter = ItemProviderFilterRegistry.INSTANCE.createFilter((ILabelProvider)this);

    public ModelRepositoryItemProvider(IWorkbenchPage page, IElementFilter rootElementFilter) {
        super(page, rootElementFilter);
    }

    public ModelRepositoryItemProvider(IWorkbenchPage page) {
        this(page, null);
    }

    public Object[] getChildren(Object element) {
        Iterable<Object> result;
        IInternalPapyrusRepository repo;
        if (element instanceof IPapyrusRepository && (repo = (IInternalPapyrusRepository)element).isConnected()) {
            DIResourceQuery.initialize(this.getViewer(), repo.getMasterView());
        }
        if (element instanceof DIModel) {
            result = Arrays.asList(((DIModel)((Object)element)).getChildren());
        } else {
            result = Arrays.asList(super.getChildren(element));
            if (element instanceof CDOResourceFolder || element instanceof IPapyrusRepository) {
                result = this.filterDIResources(result);
            }
        }
        return Iterables.toArray((Iterable)Iterables.filter(result, this.extensibleFilter), Object.class);
    }

    public Object getParent(Object element) {
        CDOResource di;
        Object result = element instanceof CDOResource ? ((di = DIResourceQuery.getAffiliateResource((CDOResource)element)) != null ? DIModel.getInstance(di, true) : super.getParent(element)) : (element instanceof DIModel ? super.getParent((Object)((DIModel)((Object)element)).getResource()) : super.getParent(element));
        return result;
    }

    protected Iterable<?> filter(Iterable<?> elements, Predicate<Object> predicate) {
        return Iterables.transform((Iterable)Iterables.filter(elements, predicate), this.resourceNodeTransformer);
    }

    protected Iterable<?> filterDIResources(Iterable<?> elements) {
        return this.filter(elements, this.resourceFilter);
    }

    public Image getImage(Object obj) {
        boolean open;
        Image result = obj instanceof IPapyrusRepository ? SharedImages.getImage((open = ((IPapyrusRepository)obj).isConnected()) ? "open_repository" : "closed_repository") : (obj instanceof DIModel ? ((DIModel)((Object)obj)).getImage() : super.getImage(obj));
        return result;
    }

    public String getText(Object obj) {
        String result = obj instanceof IInternalPapyrusRepository ? ((IInternalPapyrusRepository)obj).getName() : (obj instanceof DIModel ? ((DIModel)((Object)obj)).getName() : super.getText(obj));
        return result;
    }
}

