/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.eventbus.EventBus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.exporter.IModelExporter;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferConfiguration;
import org.eclipse.papyrus.cdo.core.importer.IModelTransferOperation;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.views.DIModel;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelExportMappingsPage;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelReferencesPage;
import org.eclipse.papyrus.cdo.internal.ui.wizards.WizardOperationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelExportWizard
extends Wizard
implements IWorkbenchWizard {
    private ModelReferencesPage referencesPage;
    private ModelExportMappingsPage mappingsPage;
    private IStructuredSelection selection;
    private IModelTransferConfiguration exportConfig;
    private IPapyrusRepository repository;
    private IContainer initialDestination;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(Messages.ModelExportWizard_0);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(false);
    }

    public void setInitialDestination(IContainer container) {
        this.initialDestination = container;
    }

    public void addPages() {
        this.exportConfig = IModelTransferConfiguration.Factory.EXPORT.create((IModelTransferOperation.Context)new WizardOperationContext(this.getShell().getDisplay(), this), this.getResourceSet(this.selection));
        final EventBus bus = new EventBus("exportWizard");
        this.referencesPage = new ModelReferencesPage(bus, false);
        this.addPage((IWizardPage)this.referencesPage);
        this.mappingsPage = new ModelExportMappingsPage(bus);
        this.addPage((IWizardPage)this.mappingsPage);
        if (this.initialDestination != null) {
            this.mappingsPage.setInitialDestination(this.initialDestination);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                for (DIModel next : ModelExportWizard.this.getSelection()) {
                    ModelExportWizard.this.exportConfig.addModelToTransfer(next.getResource().getURI());
                }
                bus.post((Object)ModelExportWizard.this.exportConfig);
                bus.post((Object)ModelExportWizard.this.repository);
            }
        });
    }

    Iterable<DIModel> getSelection() {
        ArrayListMultimap result = ArrayListMultimap.create();
        if (this.selection != null) {
            for (Object next : this.selection.toList()) {
                DIModel model = (DIModel)((Object)CDOUtils.adapt(next, DIModel.class));
                if (model == null) continue;
                URI uri = model.getResource().getURI();
                IPapyrusRepository repo = PapyrusRepositoryManager.INSTANCE.getRepositoryForURI(uri);
                if (this.repository == null) {
                    this.repository = repo;
                }
                if (repo == null) continue;
                result.put((Object)repo, (Object)model);
            }
        }
        if (result.keySet().size() > 1) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ModelExportWizard_2, (String)NLS.bind((String)Messages.ModelExportWizard_3, (Object)this.repository.getName()));
        }
        return result.get((Object)this.repository);
    }

    public boolean performFinish() {
        boolean result = true;
        IModelExporter exporter = IModelExporter.Factory.DEFAULT.create();
        Diagnostic problems = exporter.exportModels(this.mappingsPage.getMapping());
        if (problems.getSeverity() > 1) {
            StatusManager.getManager().handle(BasicDiagnostic.toIStatus((Diagnostic)problems), 2);
        }
        return result;
    }

    public void dispose() {
        if (this.exportConfig != null) {
            final IModelTransferConfiguration configuration = this.exportConfig;
            new Job(Messages.ModelExportWizard_4){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    configuration.dispose();
                    return Status.OK_STATUS;
                }
            }.schedule();
            this.exportConfig = null;
        }
        super.dispose();
    }

    ResourceSet getResourceSet(IStructuredSelection selection) {
        ResourceSet result = null;
        for (Object next : selection.toList()) {
            CDOResource resource = (CDOResource)CDOUtils.adapt(next, CDOResource.class);
            if (resource == null) continue;
            result = resource.getResourceSet();
            break;
        }
        return result;
    }
}

