/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.base.Supplier;
import com.google.common.eventbus.EventBus;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.SharedImages;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySelectionBlock {
    private final IPapyrusRepositoryManager repoMan;
    private final EventBus bus;
    private final Supplier<? extends IRunnableContext> runnableContext;
    private TableViewer repoList;
    private IPapyrusRepository selectedRepository;

    public RepositorySelectionBlock(IPapyrusRepositoryManager repoMan, EventBus bus, Supplier<? extends IRunnableContext> runnableContext) {
        this.repoMan = repoMan;
        this.bus = bus;
        this.runnableContext = runnableContext;
    }

    public Control createControl(Composite parent) {
        this.repoList = new TableViewer(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.repoList.getControl());
        this.repoList.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.repoList.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.repoList.setInput((Object)this.repoMan);
        if (this.selectedRepository != null) {
            this.repoList.setSelection((ISelection)new StructuredSelection((Object)this.selectedRepository));
            this.selected(this.selectedRepository);
        }
        this.repoList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    if (RepositorySelectionBlock.this.selectedRepository != null) {
                        RepositorySelectionBlock.this.repoList.setSelection((ISelection)new StructuredSelection((Object)RepositorySelectionBlock.this.selectedRepository));
                    }
                } else {
                    RepositorySelectionBlock.this.selected((IPapyrusRepository)sel.getFirstElement());
                }
            }
        });
        for (IPapyrusRepository next : PapyrusRepositoryManager.INSTANCE.getRepositories()) {
            if (!next.isConnected()) continue;
            this.selected(next);
            this.repoList.setSelection((ISelection)new StructuredSelection((Object)next));
            break;
        }
        return this.repoList.getControl();
    }

    public void dispose() {
    }

    public void setEnabled(boolean enabled) {
        if (this.repoList != null) {
            this.repoList.getControl().setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.repoList != null && this.repoList.getControl().isEnabled();
    }

    void selected(final IPapyrusRepository repository) {
        this.selectedRepository = repository;
        if (!repository.isConnected()) {
            try {
                ((IRunnableContext)this.runnableContext.get()).run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.RepositorySelectionBlock_0, (Object)repository.getName()), (int)-1);
                        try {
                            repository.connect();
                            long deadline = System.currentTimeMillis() + 5000L;
                            while (!repository.isConnected()) {
                                Thread.sleep(250L);
                                if (System.currentTimeMillis() >= deadline) break;
                            }
                            RepositorySelectionBlock.this.repoList.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    if (!RepositorySelectionBlock.this.repoList.getControl().isDisposed()) {
                                        RepositorySelectionBlock.this.repoList.update((Object)repository, null);
                                        RepositorySelectionBlock.this.bus.post((Object)repository);
                                    }
                                }
                            });
                        }
                        finally {
                            sub.done();
                        }
                    }
                });
            }
            catch (Exception e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.cdo.ui", Messages.RepositorySelectionBlock_1, (Throwable)e), 2);
            }
        }
        this.bus.post((Object)repository);
    }

    public void setSelectedRepository(IPapyrusRepository repository) {
        this.selectedRepository = repository;
        if (this.repoList != null) {
            this.repoList.setSelection((ISelection)new StructuredSelection((Object)this.selectedRepository));
            this.selected(this.selectedRepository);
        }
    }

    public IPapyrusRepository getSelectedRepository() {
        return this.selectedRepository;
    }

    private static class RepositoryContentProvider
    implements IStructuredContentProvider {
        private RepositoryContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            viewer.refresh();
        }

        public Object[] getElements(Object inputElement) {
            return ((IPapyrusRepositoryManager)inputElement).getRepositories().toArray();
        }

        public void dispose() {
        }
    }

    private static class RepositoryLabelProvider
    extends LabelProvider {
        private RepositoryLabelProvider() {
        }

        public Image getImage(Object element) {
            boolean open = ((IPapyrusRepository)element).isConnected();
            return SharedImages.getImage(open ? "open_repository" : "closed_repository");
        }

        public String getText(Object element) {
            return ((IPapyrusRepository)element).getName();
        }
    }
}

