/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.internal.ui.wizards;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.core.PapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.internal.ui.l10n.Messages;
import org.eclipse.papyrus.cdo.internal.ui.properties.RepositoryPropertiesBlock;
import org.eclipse.papyrus.cdo.internal.ui.wizards.ModelImportWizardPage;
import org.eclipse.papyrus.cdo.internal.ui.wizards.RepositorySelectionBlock;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RepositorySelectionPage
extends ModelImportWizardPage {
    private static final String MESSAGE = Messages.RepositorySelectionPage_0;
    private RepositorySelectionBlock repoSelectionBlock;
    private RepositoryPropertiesBlock repoBlock;
    private IPapyrusRepository repository;

    public RepositorySelectionPage(EventBus bus) {
        super("repository", Messages.RepositorySelectionPage_2, null, bus, MESSAGE);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(1, false));
        new Label(result, 0).setText(Messages.RepositorySelectionPage_3);
        this.repoSelectionBlock = new RepositorySelectionBlock((IPapyrusRepositoryManager)PapyrusRepositoryManager.INSTANCE, this.getEventBus(), (Supplier<? extends IRunnableContext>)Suppliers.ofInstance((Object)this.getContainer()));
        this.repoSelectionBlock.createControl(result);
        Group group = new Group(result, 2048);
        group.setText(Messages.RepositorySelectionPage_4);
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)new GridLayout(1, false));
        this.repoBlock = new RepositoryPropertiesBlock(this.getSelectedRepository());
        this.repoBlock.createControl((Composite)group);
        this.repoBlock.setEditable(false);
        if (this.repository != null) {
            this.repoSelectionBlock.setSelectedRepository(this.repository);
            this.repoBlock.setRepository(this.repository);
        }
        this.setControl((Control)result);
        this.validatePage();
    }

    public void dispose() {
        this.repoSelectionBlock.dispose();
        this.repoBlock.dispose();
        super.dispose();
    }

    @Subscribe
    public void selected(IPapyrusRepository repository) {
        this.repository = repository;
        if (this.repoSelectionBlock != null && this.repoSelectionBlock.getSelectedRepository() != repository) {
            this.repoSelectionBlock.setSelectedRepository(repository);
        }
        if (this.repoBlock != null) {
            this.repoBlock.setRepository(repository);
            this.validatePage();
        }
    }

    protected Diagnostic doValidatePage() {
        Diagnostic result = Diagnostic.CANCEL_INSTANCE;
        if (this.getSelectedRepository() != null) {
            result = Diagnostic.OK_INSTANCE;
        }
        return result;
    }

    public IPapyrusRepository getSelectedRepository() {
        return this.repository;
    }
}

