/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core;

import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryListener;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.core.PapyrusRepositoryEvent;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepository;
import org.eclipse.papyrus.cdo.internal.core.IInternalPapyrusRepositoryManager;

public class RepositoryManagerEventAdapter {
    private IPapyrusRepositoryManager target;
    private final ManagerListener managerListener = new ManagerListener();
    private final RepositoryListener repositoryListener = new RepositoryListener();
    private final IListener viewInvalidationListener;

    public RepositoryManagerEventAdapter() {
        this(null);
    }

    public RepositoryManagerEventAdapter(ResourceSet resourceSet) {
        this.viewInvalidationListener = resourceSet != null ? new InvalidationListener(resourceSet) : null;
    }

    public RepositoryManagerEventAdapter install(IPapyrusRepositoryManager repositoryManager) {
        IContainer container = (IContainer)repositoryManager;
        this.target = repositoryManager;
        container.addListener((IListener)this.managerListener);
        for (IPapyrusRepository iPapyrusRepository : repositoryManager.getRepositories()) {
            try {
                this.managerListener.onAdded((IContainer<IPapyrusRepository>)container, iPapyrusRepository);
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
        }
        return this;
    }

    public RepositoryManagerEventAdapter uninstall(IPapyrusRepositoryManager repositoryManager) {
        if (this.target != null && this.target == repositoryManager) {
            IContainer container = (IContainer)repositoryManager;
            for (IPapyrusRepository iPapyrusRepository : repositoryManager.getRepositories()) {
                try {
                    this.onRemoved(repositoryManager, iPapyrusRepository);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
            container.removeListener((IListener)this.managerListener);
            this.target = null;
        }
        return this;
    }

    void handleConnection(IInternalPapyrusRepository repository) {
        if (this.viewInvalidationListener != null) {
            repository.getCDOSession().addListener(this.viewInvalidationListener);
            CDOView[] cDOViewArray = repository.getCDOSession().getViews();
            int n = cDOViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOView next = cDOViewArray[n2];
                if (next.getResourceSet() == this.target) {
                    next.addListener(this.viewInvalidationListener);
                }
                ++n2;
            }
        }
        this.onConnected(repository);
    }

    void handleDisconnection(IInternalPapyrusRepository repository) {
        this.onDisconnected(repository);
    }

    protected void onAdded(IPapyrusRepositoryManager manager, IPapyrusRepository repository) {
    }

    protected void onRemoved(IPapyrusRepositoryManager manager, IPapyrusRepository repository) {
    }

    protected void onConnected(IPapyrusRepository repository) {
    }

    protected void onDisconnected(IPapyrusRepository repository) {
    }

    protected void onInvalidation(IPapyrusRepository repository, CDOView view, CDOViewInvalidationEvent event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InvalidationListener
    extends LifecycleEventAdapter {
        private final ResourceSet resourceSet;

        InvalidationListener(ResourceSet resourceSet) {
            this.resourceSet = resourceSet;
        }

        protected void notifyOtherEvent(IEvent event) {
            if (event instanceof CDOViewInvalidationEvent) {
                CDOViewInvalidationEvent invalidation = (CDOViewInvalidationEvent)event;
                IInternalPapyrusRepository repo = ((IInternalPapyrusRepositoryManager)RepositoryManagerEventAdapter.this.target).getRepository(invalidation.getSource());
                RepositoryManagerEventAdapter.this.onInvalidation(repo, invalidation.getSource(), invalidation);
            } else if (event instanceof IContainerEvent) {
                IContainerEvent containerEvent = (IContainerEvent)event;
                this.onContainerEvent((IContainerEvent<CDOView>)containerEvent);
            }
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            lifecycle.removeListener((IListener)this);
        }

        protected void onContainerEvent(IContainerEvent<CDOView> event) {
            IContainerDelta[] iContainerDeltaArray = event.getDeltas();
            int n = iContainerDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainerDelta next = iContainerDeltaArray[n2];
                if (next.getKind() == IContainerDelta.Kind.ADDED && ((CDOView)next.getElement()).getResourceSet() == this.resourceSet) {
                    ((CDOView)next.getElement()).addListener((IListener)this);
                }
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ManagerListener
    extends ContainerEventAdapter<IPapyrusRepository> {
        private ManagerListener() {
        }

        protected void onAdded(IContainer<IPapyrusRepository> container, IPapyrusRepository element) {
            element.addPapyrusRepositoryListener(RepositoryManagerEventAdapter.this.repositoryListener);
            RepositoryManagerEventAdapter.this.onAdded((IPapyrusRepositoryManager)container, element);
            if (element.isConnected()) {
                RepositoryManagerEventAdapter.this.handleConnection((IInternalPapyrusRepository)element);
            }
        }

        protected void onRemoved(IContainer<IPapyrusRepository> container, IPapyrusRepository element) {
            element.removePapyrusRepositoryListener(RepositoryManagerEventAdapter.this.repositoryListener);
            RepositoryManagerEventAdapter.this.onRemoved((IPapyrusRepositoryManager)container, element);
        }
    }

    private class RepositoryListener
    implements IPapyrusRepositoryListener {
        private RepositoryListener() {
        }

        public void papyrusRepositoryChanged(PapyrusRepositoryEvent event) {
            switch (event.getEventType()) {
                case 0: {
                    RepositoryManagerEventAdapter.this.handleConnection((IInternalPapyrusRepository)event.getSource());
                    break;
                }
                case 1: {
                    RepositoryManagerEventAdapter.this.handleDisconnection((IInternalPapyrusRepository)event.getSource());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid repository event type: " + event.getEventType());
                }
            }
        }
    }
}

