/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core.resource;

import com.google.common.collect.Iterables;
import java.io.IOException;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewInvalidationEvent;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.papyrus.cdo.core.IPapyrusRepository;
import org.eclipse.papyrus.cdo.core.IPapyrusRepositoryManager;
import org.eclipse.papyrus.cdo.core.resource.CDOAwareTransactionalEditingDomain;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.services.resourceloading.OnDemandLoadingModelSet;

public class CDOAwareModelSet
extends OnDemandLoadingModelSet {
    private final ThreadLocal<Boolean> inGetResource = new ThreadLocal();
    private final IPapyrusRepositoryManager repositoryManager;
    private IPapyrusRepository repository;
    private IListener invalidationListener;

    public CDOAwareModelSet(IPapyrusRepositoryManager repositoryManager) {
        this.setTrackingModification(false);
        this.repositoryManager = repositoryManager;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        return CDOUtils.isCDOURI(uri) ? this.basicGetEObject(uri, loadOnDemand) : super.getEObject(uri, loadOnDemand);
    }

    protected EObject basicGetEObject(URI uri, boolean loadOnDemand) {
        Resource resource = this.getResource(uri.trimFragment(), loadOnDemand);
        return resource == null ? null : resource.getEObject(uri.fragment());
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Boolean oldValue = this.inGetResource.get();
        this.inGetResource.set(Boolean.TRUE);
        try {
            Resource resource = super.getResource(uri, loadOnDemand);
            return resource;
        }
        finally {
            this.inGetResource.set(oldValue);
        }
    }

    boolean isInGetResource() {
        return this.inGetResource.get() == Boolean.TRUE;
    }

    public Resource createResource(URI uri, String contentType) {
        this.initTransaction(uri);
        return super.createResource(uri, contentType);
    }

    protected void demandLoad(Resource resource) throws IOException {
        if (CDOUtils.isCDOURI(resource.getURI())) {
            resource.load(null);
            this.resourceLoadedHook(resource);
        } else {
            super.demandLoad(resource);
        }
    }

    protected void resourceLoadedHook(Resource resource) {
        for (Diagram next : Iterables.filter((Iterable)resource.getContents(), Diagram.class)) {
            DawnDiagramUpdater.initializeElement((Diagram)next);
        }
    }

    public CDOView getCDOView() {
        CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)this);
        CDOView[] views = viewSet == null ? null : viewSet.getViews();
        return views != null && views.length > 0 ? views[0] : null;
    }

    public void createModels(URI newURI) {
        this.initTransaction(newURI);
        super.createModels(newURI);
    }

    public void loadModels(URI uri) throws ModelMultiException {
        this.initTransaction(uri);
        super.loadModels(uri);
    }

    protected void initTransaction(URI uri) {
        if (this.getCDOView() == null) {
            if (this.repository == null) {
                this.repository = this.repositoryManager.getRepositoryForURI(uri);
            }
            if (this.repository != null) {
                this.repository.createTransaction((ResourceSet)this);
                CDOView view = this.getCDOView();
                if (view != null) {
                    view.addListener(this.getInvalidationListener());
                }
            }
        }
    }

    public void unload() {
        if (this.repository != null && this.getCDOView() != null) {
            CDOView view = this.getCDOView();
            if (view != null) {
                view.removeListener(this.getInvalidationListener());
            }
            this.invalidationListener = null;
            this.repository.close((ResourceSet)this);
        }
        this.repository = null;
        super.unload();
    }

    protected final IListener getInvalidationListener() {
        if (this.invalidationListener == null) {
            this.invalidationListener = this.createInvalidationListener();
        }
        return this.invalidationListener;
    }

    protected IListener createInvalidationListener() {
        return new IListener(){

            public void notifyEvent(IEvent event) {
                TransactionalEditingDomain domain;
                if (event instanceof CDOViewInvalidationEvent && (domain = CDOAwareModelSet.this.getTransactionalEditingDomain()) instanceof CDOAwareTransactionalEditingDomain) {
                    ((CDOAwareTransactionalEditingDomain)domain).fireResourceSetChanged((CDOViewInvalidationEvent)event);
                }
            }
        };
    }
}

